/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXRadio;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.StringList;

public final class DialogInsert
extends BaseXDialog {
    public final StringList result = new StringList();
    public int kind;
    private final BaseXBack buttons;
    private final BaseXBack back;
    private final BaseXLabel info;
    private final BaseXTextField input1;
    private final TextPanel input2;
    private final BaseXLabel label1 = new BaseXLabel(Text.NAME + ": ", true, true).border(0, 0, 0, 0);
    private final BaseXLabel label2 = new BaseXLabel(Text.VALUE + ": ", true, true).border(0, 0, 0, 0);
    private final BaseXRadio[] radio;

    public DialogInsert(GUI gui) {
        super(gui, Text.INSERT_NEW_DATA);
        this.input1 = new BaseXTextField(this);
        BaseXLayout.setWidth(this.input1, 500);
        this.input2 = new TextPanel(this, true);
        this.input2.addKeyListener(this.keys);
        BaseXLayout.setWidth(this.input2, 500);
        BaseXBack knd = new BaseXBack(new TableLayout(1, 5));
        ButtonGroup group = new ButtonGroup();
        ActionListener al = e -> this.change(e.getSource());
        int lkind = gui.gopts.get(GUIOptions.LASTINSERT);
        int nl = Text.NODE_KINDS.length;
        this.radio = new BaseXRadio[nl];
        for (int i = 1; i < nl; ++i) {
            this.radio[i] = new BaseXRadio(this, Text.NODE_KINDS[i], false);
            this.radio[i].addActionListener(al);
            this.radio[i].setSelected(i == lkind);
            this.radio[i].addKeyListener(this.keys);
            group.add(this.radio[i]);
            knd.add(this.radio[i]);
        }
        this.set(knd, "North");
        this.back = new BaseXBack().border(10, 0, 0, 0);
        this.set(this.back, "Center");
        BaseXBack pp = new BaseXBack(new BorderLayout());
        this.info = new BaseXLabel(" ").border(12, 0, 6, 0);
        pp.add((Component)this.info, "West");
        this.buttons = this.okCancel();
        pp.add((Component)this.buttons, "East");
        this.set(pp, "South");
        this.setResizable(true);
        this.change(this.radio[lkind]);
        this.action(null);
        this.finish();
    }

    private void change(Object src) {
        BaseXBack b;
        int n = 0;
        int rl = this.radio.length;
        for (int r = 0; r < rl; ++r) {
            if (src != this.radio[r]) continue;
            n = r;
        }
        int h = n == 3 ? this.input1.getHeight() : 350;
        this.input2.setPreferredSize(new Dimension(this.input2.getPreferredSize().width, h));
        this.back.removeAll();
        this.back.layout(new BorderLayout(0, 4));
        if (n != 2 && n != 4) {
            b = new BaseXBack(new BorderLayout(0, 4));
            b.add((Component)this.label1, "North");
            b.add((Component)this.input1, "Center");
            this.back.add((Component)b, "North");
        }
        if (n != 1) {
            b = new BaseXBack(new BorderLayout(0, 4));
            b.add((Component)this.label2, "North");
            b.add((Component)new SearchEditor(this.gui, this.input2), "Center");
            this.back.add((Component)b, "Center");
        }
        this.pack();
    }

    @Override
    public void action(Object cmp) {
        int nl = Text.NODE_KINDS.length;
        for (int n = 1; n < nl; ++n) {
            if (!this.radio[n].isSelected()) continue;
            this.kind = n;
        }
        this.gui.gopts.set(GUIOptions.LASTINSERT, this.kind);
        this.ok = this.kind != 2 || this.input2.getText().length != 0;
        String msg = null;
        if (this.kind != 2 && this.kind != 4) {
            this.ok = XMLToken.isQName(Token.token(this.input1.getText()));
            if (!this.ok && !this.input1.getText().isEmpty()) {
                msg = Util.info(Text.INVALID_X, Text.NAME);
            }
        }
        this.info.setText(msg, GUIConstants.Msg.ERROR);
        DialogInsert.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        super.close();
        String in1 = this.input1.getText();
        String in2 = Token.string(this.input2.getText());
        switch (this.kind) {
            case 3: 
            case 5: {
                ((StringList)((Object)this.result.add(in1))).add(in2);
                break;
            }
            case 1: {
                this.result.add(in1);
                break;
            }
            case 2: 
            case 4: {
                this.result.add(in2);
            }
        }
    }
}

