/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.util.ArrayList;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.parse.PasswordReader;
import org.basex.core.parse.StringParser;
import org.basex.core.parse.XMLParser;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;

public abstract class CommandParser {
    final String input;
    final Context ctx;
    PasswordReader pwReader;
    String uri = "";
    boolean single;
    boolean suggest;

    CommandParser(String input, Context ctx) {
        this.ctx = ctx;
        this.input = input;
    }

    public static CommandParser get(String input, Context ctx) {
        return input.startsWith("<") ? new XMLParser(input, ctx) : new StringParser(input, ctx);
    }

    public final CommandParser pwReader(PasswordReader pr) {
        this.pwReader = pr;
        return this;
    }

    public final CommandParser baseURI(String base) {
        this.uri = base;
        return this;
    }

    public final CommandParser suggest() {
        this.suggest = true;
        return this;
    }

    public final Command parseSingle() throws QueryException {
        this.single = true;
        return this.parse()[0];
    }

    public final Command[] parse() throws QueryException {
        ArrayList<Command> cmds = new ArrayList<Command>();
        this.parse(cmds);
        if (!this.single || cmds.size() == 1) {
            return cmds.toArray(new Command[cmds.size()]);
        }
        throw new QueryException(null, QNm.EMPTY, Text.SINGLE_CMD, new Object[0]);
    }

    protected abstract void parse(ArrayList<Command> var1) throws QueryException;
}

