/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.Date;
import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.util.DateTime;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class CreateBackup
extends ABackup {
    public CreateBackup(String arg) {
        super(arg);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!Databases.validName(name, true)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList dbs = this.context.listDBs(name);
        if (dbs.isEmpty()) {
            return this.error(Text.DB_NOT_FOUND_X, name);
        }
        boolean ok = true;
        for (String db : dbs) {
            if (MetaData.file(this.soptions.dbPath(db), "upd").exists()) {
                this.info(Text.DB_UPDATED_X, db);
                ok = false;
                continue;
            }
            try {
                CreateBackup.backup(db, this.soptions, this);
                this.info(Text.DB_BACKUP_X, db, this.jc().performance);
            }
            catch (IOException ex) {
                Util.debug(ex);
                this.info(Text.DB_NOT_BACKUP_X, db);
                ok = false;
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backup(String db, StaticOptions sopts, CreateBackup cmd) throws IOException {
        String backup = db + '-' + DateTime.format(new Date(), DateTime.DATETIME) + ".zip";
        IOFile zf = sopts.dbPath(backup);
        Zip zip = new Zip(zf);
        try {
            if (cmd != null) {
                cmd.pushJob(zip);
            }
            IOFile dbpath = sopts.dbPath(db);
            StringList files = dbpath.descendants();
            files.delete("upd.basex");
            zip.zip(dbpath, files);
        }
        finally {
            if (cmd != null) {
                cmd.popJob();
            }
        }
    }

    @Override
    public void addLocks() {
        super.addLocks();
        this.addLocks(this.jc().locks.reads, 0);
    }

    @Override
    public String shortInfo() {
        return Text.BACKUP;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.BACKUP)).args();
    }
}

