/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.list.ElementList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class ObjectList<E, L extends ObjectList<E, ?>>
extends ElementList
implements Iterable<E> {
    public E[] list;

    protected ObjectList(E ... list) {
        this.list = list;
    }

    protected abstract E[] newList(int var1);

    public E get(int i) {
        return i < this.size ? (E)this.list[i] : null;
    }

    public boolean contains(E element) {
        E[] lst = this.list;
        int s = this.size;
        int l = 0;
        while (l < s) {
            if (this.eq(lst[l], element)) {
                return true;
            }
            ++l;
        }
        return false;
    }

    public L add(E element) {
        int s = this.size;
        E[] lst = this.list;
        if (s == lst.length) {
            lst = Array.copy(lst, this.newList(this.newSize()));
        }
        lst[s] = element;
        this.list = lst;
        this.size = s + 1;
        return (L)this;
    }

    public final L add(E ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        E[] lst = this.list;
        if (ns > lst.length) {
            lst = Array.copy(lst, this.newList(this.newSize(ns)));
        }
        System.arraycopy(elements, 0, lst, s, l);
        this.list = lst;
        this.size = ns;
        return (L)this;
    }

    public final L add(L elements) {
        for (E e : elements) {
            this.add((L)e);
        }
        return (L)this;
    }

    public final L set(int index, E element) {
        E[] lst = this.list;
        int sz = this.size;
        if (index >= lst.length) {
            lst = Array.copy(lst, this.newList(this.newSize(index + 1)));
        }
        lst[index] = element;
        this.list = lst;
        this.size = Math.max(sz, index + 1);
        return (L)this;
    }

    public final void insert(int index, E ... elements) {
        int l = elements.length;
        if (l == 0) {
            return;
        }
        int sz = this.size;
        E[] lst = this.list;
        if (sz + l > lst.length) {
            lst = Array.copy(lst, this.newList(this.newSize(sz + l)));
        }
        Array.move(lst, index, l, sz - index);
        System.arraycopy(elements, 0, lst, index, l);
        this.list = lst;
        this.size = sz + l;
    }

    public final E remove(int index) {
        E[] lst = this.list;
        E e = lst[index];
        Array.move(lst, index + 1, -1, --this.size - index);
        return e;
    }

    public boolean delete(E element) {
        E[] lst = this.list;
        int sz = this.size;
        int s = 0;
        int i = 0;
        while (i < sz) {
            if (!this.eq(lst[i], element)) {
                lst[s++] = lst[i];
            }
            ++i;
        }
        this.size = s;
        return sz != s;
    }

    public void delete(L elements) {
        for (E e : elements) {
            this.delete(e);
        }
    }

    public final E pop() {
        return this.list[--this.size];
    }

    public final void push(E element) {
        this.add((L)element);
    }

    public E peek() {
        return this.list[this.size - 1];
    }

    public final E[] toArray() {
        return Array.copy(this.list, this.newList(this.size));
    }

    public final E[] finish() {
        E[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Array.copy(lst, this.newList(s));
    }

    public E[] next() {
        E[] lst = this.toArray();
        this.reset();
        return lst;
    }

    public final L sort(Comparator<E> comp, boolean ascending) {
        Arrays.sort(this.list, 0, this.size, ascending ? comp : Collections.reverseOrder(comp));
        return (L)this;
    }

    public boolean eq(E element1, E element2) {
        return Objects.equals(element1, element2);
    }

    public final L unique() {
        E[] lst = this.list;
        int s = this.size;
        if (s != 0) {
            int ns = 0;
            int l = 1;
            while (l < s) {
                if (!this.eq(lst[l], lst[ns])) {
                    lst[++ns] = lst[l];
                }
                ++l;
            }
            this.size = ns + 1;
        }
        return (L)this;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator(this.list, this.size);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectList)) {
            return false;
        }
        ObjectList f = (ObjectList)obj;
        int s = this.size;
        if (s != f.size) {
            return false;
        }
        E[] lst1 = this.list;
        E[] lst2 = f.list;
        int l = 0;
        while (l < s) {
            if (!this.eq(lst1[l], lst2[l])) {
                return false;
            }
            ++l;
        }
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

