/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.ArrayList;
import java.util.Scanner;
import org.basex.core.Text;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Table {
    private static final int DIST = 2;
    public final TokenList header = new TokenList();
    public final BoolList align = new BoolList();
    public final ArrayList<TokenList> contents = new ArrayList();
    public String description;

    public Table() {
    }

    public Table(String in) {
        if (in.isEmpty()) {
            return;
        }
        Scanner scan = new Scanner(in);
        byte[] line = Token.token(scan.nextLine());
        IntList il = new IntList();
        int l = 0;
        int ll = line.length;
        while (l < ll) {
            il.add(l);
            while (++l + 1 < ll && (line[l] != 32 || line[l + 1] != 32)) {
            }
            this.header.add(Token.substring(line, il.get(il.size() - 1), l));
            while (++l < ll && line[l] == 32) {
            }
        }
        il.add(l);
        scan.nextLine();
        int s = il.size() - 1;
        while ((line = Token.token(scan.nextLine())).length != 0) {
            TokenList entry = new TokenList();
            int e = 0;
            while (e < s) {
                entry.add(Token.trim(Token.substring(line, il.get(e), il.get(e + 1))));
                ++e;
            }
            this.contents.add(entry);
        }
    }

    public Table sort() {
        this.contents.sort((tl1, tl2) -> Token.diff(Token.lc((byte[])tl1.get(0)), Token.lc((byte[])tl2.get(0))));
        return this;
    }

    public Table toTop(byte[] top) {
        int i = 0;
        while (i < this.contents.size()) {
            if (Token.eq(top, (byte[])this.contents.get(i).get(0))) {
                this.contents.add(0, this.contents.remove(i));
                break;
            }
            ++i;
        }
        return this;
    }

    public byte[] finish() {
        int[] ind = new int[this.header.size()];
        int size = this.header.size();
        int s = 0;
        while (s < size) {
            for (TokenList e : this.contents) {
                ind[s] = Math.max(ind[s], ((byte[])e.get(s)).length);
            }
            ind[s] = Math.max(ind[s], ((byte[])this.header.get(s)).length);
            ++s;
        }
        TokenBuilder tb = new TokenBuilder();
        int u = 0;
        while (u < size) {
            byte[] s2 = (byte[])this.header.get(u);
            int is = ind[u] - s2.length + 2;
            tb.add(s2);
            int i = 0;
            while (i < is) {
                tb.add(32);
                ++i;
            }
            ++u;
        }
        tb.add(Text.NL);
        u = 0;
        while (u < size) {
            int i = 0;
            while (i < ind[u] + (u + 1 == size ? 0 : 2)) {
                tb.add(45);
                ++i;
            }
            ++u;
        }
        tb.add(Text.NL);
        for (TokenList e : this.contents) {
            int u2 = 0;
            while (u2 < size) {
                int i;
                byte[] s3 = (byte[])e.get(u2);
                int is = ind[u2] - s3.length;
                if (u2 < this.align.size() && this.align.get(u2)) {
                    i = 0;
                    while (i < is) {
                        tb.add(32);
                        ++i;
                    }
                    tb.add(s3);
                } else {
                    tb.add(s3);
                    i = 0;
                    while (i < is) {
                        tb.add(32);
                        ++i;
                    }
                }
                i = 0;
                while (i < 2) {
                    tb.add(32);
                    ++i;
                }
                ++u2;
            }
            tb.add(Text.NL);
        }
        if (this.description != null) {
            tb.add(Text.NL).addExt(this.description, this.contents.size()).add(".");
        }
        return tb.finish();
    }

    public String toString() {
        return Token.string(this.finish());
    }
}

