/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Map;
import java.util.TreeMap;
import org.basex.util.Array;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.LongList;

public final class FreeSlots {
    private final TreeMap<Integer, LongList> free = new TreeMap();
    private int slots;

    public void add(int size, long offset) {
        this.add(size, offset, true);
    }

    public long get(int size, long offset) {
        long off = -1L;
        Map.Entry<Integer, LongList> entry = this.free.ceilingEntry(size);
        if (entry != null) {
            int slotSize = entry.getKey();
            if (slotSize < size) {
                throw Util.notExpected("Free slot is too small: % < %", slotSize, size);
            }
            LongList offsets = entry.getValue();
            off = offsets.pop();
            --this.slots;
            if (offsets.isEmpty()) {
                this.free.remove(slotSize);
            }
            if (slotSize > size) {
                if (off + (long)slotSize > offset) {
                    throw Util.notExpected("Free slot exceeds file offset: % + % > %", off, slotSize, offset);
                }
                this.add(slotSize - size, off + (long)size);
            }
        }
        return off == -1L ? offset : off;
    }

    private void add(int size, long offset, boolean opt) {
        this.free.computeIfAbsent(size, k -> new LongList()).add(offset);
        ++this.slots;
        if (opt) {
            this.optimize();
        }
    }

    private void optimize() {
        if (this.free.isEmpty()) {
            return;
        }
        int size = this.slots;
        LongList offList = new LongList(size);
        IntList sizeList = new IntList(size);
        this.free.forEach((slotSize, list) -> {
            int ll = list.size();
            int l = 0;
            while (l < ll) {
                offList.add(list.get(l));
                sizeList.add((int)slotSize);
                ++l;
            }
        });
        if (size != offList.size()) {
            throw Util.notExpected("Wrong slot count: % vs. %", size, offList.size());
        }
        long[] offsets = offList.finish();
        int[] slotSizes = sizeList.finish();
        int[] index = Array.createOrder(offsets, true);
        this.free.clear();
        this.slots = 0;
        long offset = offsets[0];
        int slotSize2 = slotSizes[index[0]];
        int c = 1;
        while (c < size) {
            long o = offsets[c];
            int s = slotSizes[index[c]];
            if (o == offset + (long)slotSize2) {
                slotSize2 += s;
            } else {
                this.add(slotSize2, offset, false);
                offset = o;
                slotSize2 = s;
            }
            ++c;
        }
        this.add(slotSize2, offset, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FREE SLOTS: " + this.free.size() + '\n');
        this.free.forEach((key, value) -> {
            StringBuilder stringBuilder2 = sb.append("  ").append(key).append(": ").append(value).append('\n');
        });
        return sb.toString();
    }
}

