/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Iterator;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.TreeSlice;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.tree.LeafNode;
import org.basex.query.value.seq.tree.PartialLeafNode;
import org.basex.query.value.seq.tree.SmallSeq;
import org.basex.query.value.seq.tree.TreeSeq;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

final class BigSeq
extends TreeSeq {
    final Item[] left;
    final FingerTree<Item, Item> middle;
    final Item[] right;

    BigSeq(Item[] left, FingerTree<Item, Item> middle, Item[] right, Type type) {
        super((long)left.length + middle.size() + (long)right.length, type);
        this.left = left;
        this.middle = middle;
        this.right = right;
        assert (left.length >= 4 && left.length <= 19 && right.length >= 4 && right.length <= 19);
    }

    @Override
    public Item itemAt(long index) {
        if (index < (long)this.left.length) {
            return this.left[(int)index];
        }
        long midSize = this.size - (long)this.right.length;
        if (index >= midSize) {
            return this.right[(int)(index - midSize)];
        }
        return this.middle.get(index - (long)this.left.length);
    }

    @Override
    public TreeSeq reverse(QueryContext qc) {
        qc.checkStop();
        int l = this.left.length;
        int r = this.right.length;
        Item[] newLeft = new Item[r];
        Item[] newRight = new Item[l];
        int i = 0;
        while (i < r) {
            newLeft[i] = this.right[r - 1 - i];
            ++i;
        }
        i = 0;
        while (i < l) {
            newRight[i] = this.left[l - 1 - i];
            ++i;
        }
        return new BigSeq(newLeft, this.middle.reverse(qc), newRight, this.type);
    }

    @Override
    public TreeSeq insert(long pos, Item value, QueryContext qc) {
        qc.checkStop();
        int l = this.left.length;
        if (pos <= (long)l) {
            int p = (int)pos;
            Item[] temp = BigSeq.slice(this.left, 0, l + 1);
            System.arraycopy(temp, p, temp, p + 1, l - p);
            temp[p] = value;
            if (l < 19) {
                return new BigSeq(temp, this.middle, this.right, null);
            }
            int m = (l + 1) / 2;
            return new BigSeq(BigSeq.slice(temp, 0, m), this.middle.cons(new LeafNode(BigSeq.slice(temp, m, l + 1))), this.right, null);
        }
        long midSize = this.middle.size();
        if (pos - (long)l < midSize) {
            return new BigSeq(this.left, this.middle.insert(pos - (long)l, value, qc), this.right, null);
        }
        int r = this.right.length;
        int p = (int)(pos - (long)l - midSize);
        Item[] temp = BigSeq.slice(this.right, 0, r + 1);
        System.arraycopy(temp, p, temp, p + 1, r - p);
        temp[p] = value;
        if (r < 19) {
            return new BigSeq(this.left, this.middle, temp, null);
        }
        int m = (r + 1) / 2;
        return new BigSeq(this.left, this.middle.snoc(new LeafNode(BigSeq.slice(temp, 0, m))), BigSeq.slice(temp, m, r + 1), null);
    }

    @Override
    public TreeSeq remove(long pos, QueryContext qc) {
        qc.checkStop();
        if (pos < (long)this.left.length) {
            int p = (int)pos;
            int l = this.left.length;
            if (l > 4) {
                Item[] newLeft = new Item[l - 1];
                System.arraycopy(this.left, 0, newLeft, 0, p);
                System.arraycopy(this.left, p + 1, newLeft, p, newLeft.length - p);
                return new BigSeq(newLeft, this.middle, this.right, this.type);
            }
            if (this.middle.isEmpty()) {
                int r = this.right.length;
                int n = l - 1 + r;
                Item[] vals = new Item[n];
                System.arraycopy(this.left, 0, vals, 0, p);
                System.arraycopy(this.left, p + 1, vals, p, l - 1 - p);
                System.arraycopy(this.right, 0, vals, l - 1, r);
                return BigSeq.fromMerged(vals, this.type);
            }
            Item[] head = ((LeafNode)this.middle.head()).values;
            int r = head.length;
            int n = l - 1 + r;
            if (r > 8) {
                int move = (r - 8 + 1) / 2;
                Item[] newLeft = new Item[l - 1 + move];
                System.arraycopy(this.left, 0, newLeft, 0, p);
                System.arraycopy(this.left, p + 1, newLeft, p, l - 1 - p);
                System.arraycopy(head, 0, newLeft, l - 1, move);
                Item[] newHead = BigSeq.slice(head, move, r);
                return new BigSeq(newLeft, this.middle.replaceHead(new LeafNode(newHead)), this.right, this.type);
            }
            Item[] newLeft = new Item[n];
            System.arraycopy(this.left, 0, newLeft, 0, p);
            System.arraycopy(this.left, p + 1, newLeft, p, l - 1 - p);
            System.arraycopy(head, 0, newLeft, l - 1, r);
            return new BigSeq(newLeft, this.middle.tail(), this.right, this.type);
        }
        long midSize = this.middle.size();
        long rightOffset = (long)this.left.length + midSize;
        if (pos >= rightOffset) {
            int p = (int)(pos - rightOffset);
            int r = this.right.length;
            if (r > 4) {
                Item[] newRight = new Item[r - 1];
                System.arraycopy(this.right, 0, newRight, 0, p);
                System.arraycopy(this.right, p + 1, newRight, p, r - 1 - p);
                return new BigSeq(this.left, this.middle, newRight, this.type);
            }
            if (this.middle.isEmpty()) {
                int l = this.left.length;
                int n = l + r - 1;
                Item[] vals = new Item[n];
                System.arraycopy(this.left, 0, vals, 0, l);
                System.arraycopy(this.right, 0, vals, l, p);
                System.arraycopy(this.right, p + 1, vals, l + p, r - 1 - p);
                return BigSeq.fromMerged(vals, this.type);
            }
            Item[] last = ((LeafNode)this.middle.last()).values;
            int l = last.length;
            int n = l + r - 1;
            if (l > 8) {
                int move = (l - 8 + 1) / 2;
                Item[] newLast = BigSeq.slice(last, 0, l - move);
                Item[] newRight = new Item[r - 1 + move];
                System.arraycopy(last, l - move, newRight, 0, move);
                System.arraycopy(this.right, 0, newRight, move, p);
                System.arraycopy(this.right, p + 1, newRight, move + p, r - 1 - p);
                return new BigSeq(this.left, this.middle.replaceLast(new LeafNode(newLast)), newRight, this.type);
            }
            Item[] newRight = new Item[n];
            System.arraycopy(last, 0, newRight, 0, l);
            System.arraycopy(this.right, 0, newRight, l, p);
            System.arraycopy(this.right, p + 1, newRight, l + p, r - 1 - p);
            return new BigSeq(this.left, this.middle.init(), newRight, this.type);
        }
        TreeSlice<Item, Item> slice = this.middle.remove(pos - (long)this.left.length, qc);
        if (slice.isTree()) {
            return new BigSeq(this.left, slice.getTree(), this.right, this.type);
        }
        Item[] mid = ((PartialLeafNode)slice.getPartial()).elems;
        int l = this.left.length;
        int m = mid.length;
        int r = this.right.length;
        if (l > r) {
            int move = (l - 4 + 1) / 2;
            Item[] newLeft = BigSeq.slice(this.left, 0, l - move);
            Item[] newMid = BigSeq.slice(this.left, l - move, l + m);
            System.arraycopy(mid, 0, newMid, move, m);
            return new BigSeq(newLeft, FingerTree.singleton(new LeafNode(newMid)), this.right, this.type);
        }
        if (r > 4) {
            int move = (r - 4 + 1) / 2;
            Item[] newMid = BigSeq.slice(mid, 0, m + move);
            System.arraycopy(this.right, 0, newMid, m, move);
            Item[] newRight = BigSeq.slice(this.right, move, r);
            return new BigSeq(this.left, FingerTree.singleton(new LeafNode(newMid)), newRight, this.type);
        }
        int ml = m / 2;
        int mr = m - ml;
        Item[] newLeft = BigSeq.slice(this.left, 0, l + ml);
        System.arraycopy(mid, 0, newLeft, l, ml);
        Item[] newRight = BigSeq.slice(this.right, -mr, r);
        System.arraycopy(mid, ml, newRight, 0, mr);
        Type rt = this.type;
        return new BigSeq(newLeft, FingerTree.empty(), newRight, rt);
    }

    @Override
    protected Seq subSeq(long offset, long length, QueryContext qc) {
        Item[] newRight;
        FingerTree<Item, Item> newMiddle;
        FingerTree<Item, Item> mid1;
        Item[] newLeft;
        FingerTree<Item, Item> mid;
        int inRight;
        qc.checkStop();
        long midSize = this.middle.size();
        long end = offset + length;
        if (end <= (long)this.left.length) {
            int p = (int)offset;
            int n = (int)length;
            if (length <= 7L) {
                return new SmallSeq(BigSeq.slice(this.left, p, p + n), this.type);
            }
            int mid2 = p + n / 2;
            Type rt = this.type;
            return new BigSeq(BigSeq.slice(this.left, p, mid2), FingerTree.empty(), BigSeq.slice(this.left, mid2, p + n), rt);
        }
        long rightOffset = (long)this.left.length + midSize;
        if (offset >= rightOffset) {
            int p = (int)(offset - rightOffset);
            int n = (int)length;
            if (length <= 7L) {
                return new SmallSeq(BigSeq.slice(this.right, p, p + n), this.type);
            }
            int mid3 = p + n / 2;
            Type rt = this.type;
            return new BigSeq(BigSeq.slice(this.right, p, mid3), FingerTree.empty(), BigSeq.slice(this.right, mid3, p + n), rt);
        }
        int inLeft = offset < (long)this.left.length ? (int)((long)this.left.length - offset) : 0;
        int n = inRight = end > rightOffset ? (int)(end - rightOffset) : 0;
        if (inLeft >= 4 && inRight >= 4) {
            Item[] newLeft2 = inLeft == this.left.length ? this.left : BigSeq.slice(this.left, (int)offset, this.left.length);
            Item[] newRight2 = inRight == this.right.length ? this.right : BigSeq.slice(this.right, 0, inRight);
            return new BigSeq(newLeft2, this.middle, newRight2, this.type);
        }
        if (this.middle.isEmpty()) {
            Item[] out;
            if (inLeft == 0) {
                out = inRight == this.right.length ? this.right : BigSeq.slice(this.right, 0, inRight);
            } else if (inRight == 0) {
                out = inLeft == this.left.length ? this.left : BigSeq.slice(this.left, this.left.length - inLeft, this.left.length);
            } else {
                out = BigSeq.slice(this.left, this.left.length - inLeft, this.left.length + inRight);
                System.arraycopy(this.right, 0, out, inLeft, inRight);
            }
            return BigSeq.fromMerged(out, this.type);
        }
        long inMiddle = length - (long)inLeft - (long)inRight;
        if (inMiddle == midSize) {
            mid = this.middle;
        } else {
            long off = offset < (long)this.left.length ? 0L : offset - (long)this.left.length;
            TreeSlice<Item, Item> slice = this.middle.slice(off, inMiddle);
            if (!slice.isTree()) {
                Item[] single = ((PartialLeafNode)slice.getPartial()).elems;
                if (inLeft > 0) {
                    Item[] out = BigSeq.slice(this.left, (int)offset, this.left.length + single.length);
                    System.arraycopy(single, 0, out, inLeft, single.length);
                    return BigSeq.fromMerged(out, this.type);
                }
                if (inRight > 0) {
                    Item[] out = BigSeq.slice(single, 0, single.length + inRight);
                    System.arraycopy(this.right, 0, out, single.length, inRight);
                    return BigSeq.fromMerged(out, this.type);
                }
                return new SmallSeq(single, this.type);
            }
            mid = slice.getTree();
        }
        int off = this.left.length - inLeft;
        if (inLeft >= 4) {
            newLeft = inLeft == this.left.length ? this.left : BigSeq.slice(this.left, off, this.left.length);
            mid1 = mid;
        } else {
            Item[] head = ((LeafNode)mid.head()).values;
            if (inLeft == 0) {
                newLeft = head;
            } else {
                newLeft = BigSeq.slice(head, -inLeft, head.length);
                System.arraycopy(this.left, off, newLeft, 0, inLeft);
            }
            mid1 = mid.tail();
        }
        if (inRight >= 4) {
            newMiddle = mid1;
            newRight = inRight == this.right.length ? this.right : BigSeq.slice(this.right, 0, inRight);
        } else if (!mid1.isEmpty()) {
            Item[] last = ((LeafNode)mid1.last()).values;
            newMiddle = mid1.init();
            if (inRight == 0) {
                newRight = last;
            } else {
                newRight = BigSeq.slice(last, 0, last.length + inRight);
                System.arraycopy(this.right, 0, newRight, last.length, inRight);
            }
        } else {
            if (inRight == 0) {
                return BigSeq.fromMerged(newLeft, this.type);
            }
            int n2 = newLeft.length + inRight;
            Item[] out = BigSeq.slice(newLeft, 0, n2);
            System.arraycopy(this.right, 0, out, newLeft.length, inRight);
            return BigSeq.fromMerged(out, this.type);
        }
        return new BigSeq(newLeft, newMiddle, newRight, this.type);
    }

    private static TreeSeq fromMerged(Item[] merged, Type rt) {
        if (merged.length <= 7) {
            return new SmallSeq(merged, rt);
        }
        int mid = merged.length / 2;
        return new BigSeq(BigSeq.slice(merged, 0, mid), FingerTree.empty(), BigSeq.slice(merged, mid, merged.length), rt);
    }

    @Override
    public TreeSeq concat(TreeSeq seq) {
        Type tp;
        Type type = tp = this.type.eq(seq.type) ? this.type : null;
        if (seq instanceof SmallSeq) {
            Item[] newRight = BigSeq.concat(this.right, ((SmallSeq)seq).elems);
            int r = newRight.length;
            if (r <= 19) {
                return new BigSeq(this.left, this.middle, newRight, tp);
            }
            int mid = r / 2;
            Item[] leaf = BigSeq.slice(newRight, 0, mid);
            FingerTree<Item, Item> newMid = this.middle.snoc(new LeafNode(leaf));
            return new BigSeq(this.left, newMid, BigSeq.slice(newRight, mid, r), tp);
        }
        BigSeq bigOther = (BigSeq)seq;
        Item[] ls = this.right;
        Item[] rs = bigOther.left;
        int l = ls.length;
        int n = l + rs.length;
        int k = (n + 15 - 1) / 15;
        int s = (n + k - 1) / k;
        Node[] midNodes = new Node[k];
        int p = 0;
        int i = 0;
        while (i < k) {
            int curr = Math.min(n - p, s);
            Item[] arr = new Item[curr];
            int j = 0;
            while (j < curr) {
                arr[j] = p < l ? ls[p] : rs[p - l];
                ++j;
                ++p;
            }
            midNodes[i] = new LeafNode(arr);
            ++i;
        }
        return new BigSeq(this.left, this.middle.concat(midNodes, n, bigOther.middle), bigOther.right, tp);
    }

    @Override
    public ListIterator<Item> iterator(long start) {
        ListIterator<Item> sub;
        int startPos;
        final Item[] ls = this.left;
        final Item[] rs = this.right;
        final int l = ls.length;
        final int r = rs.length;
        final long m = this.middle.size();
        if (start < (long)l) {
            startPos = (int)start - l;
            sub = this.middle.listIterator(0L);
        } else if (start - (long)l < m) {
            startPos = 0;
            sub = this.middle.listIterator(start - (long)l);
        } else {
            startPos = (int)(start - (long)l - m) + 1;
            sub = this.middle.listIterator(m);
        }
        return new ListIterator<Item>(startPos){
            int pos;
            {
                this.pos = n;
            }

            @Override
            public int nextIndex() {
                return this.pos < 0 ? l + this.pos : (this.pos > 0 ? (int)((long)l + m + (long)this.pos - 1L) : l + sub.nextIndex());
            }

            @Override
            public boolean hasNext() {
                return this.pos <= r;
            }

            @Override
            public Item next() {
                if (this.pos < 0) {
                    return ls[l + this.pos++];
                }
                if (this.pos == 0) {
                    if (sub.hasNext()) {
                        return (Item)sub.next();
                    }
                    this.pos = 1;
                }
                return rs[this.pos++ - 1];
            }

            @Override
            public int previousIndex() {
                return this.pos < 0 ? l + this.pos - 1 : (this.pos > 0 ? (int)((long)l + m + (long)this.pos - 2L) : l + sub.previousIndex());
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > -l;
            }

            @Override
            public Item previous() {
                if (this.pos > 0 && --this.pos > 0) {
                    return rs[this.pos - 1];
                }
                if (this.pos == 0) {
                    if (sub.hasPrevious()) {
                        return (Item)sub.previous();
                    }
                    this.pos = -1;
                    return ls[l - 1];
                }
                return ls[l + --this.pos];
            }

            @Override
            public void add(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void set(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){
            private Iterator<Item> sub;

            @Override
            public Item next() {
                long p;
                if (this.pos >= this.size) {
                    return null;
                }
                if ((p = this.pos++) < (long)BigSeq.this.left.length) {
                    return BigSeq.this.left[(int)p];
                }
                long r = this.size - (long)BigSeq.this.right.length;
                if (p >= r) {
                    return BigSeq.this.right[(int)(p - r)];
                }
                if (this.sub == null) {
                    this.sub = BigSeq.this.middle.iterator();
                }
                return this.sub.next();
            }

            @Override
            public Value value() {
                return BigSeq.this;
            }

            @Override
            public Item get(long i) {
                return BigSeq.this.itemAt(i);
            }

            @Override
            public Value value(QueryContext qc) {
                return this.value();
            }
        };
    }

    @Override
    TreeSeq consSmall(Item[] vals) {
        int a = vals.length;
        int b = this.left.length;
        int n = a + b;
        if (n <= 19) {
            return new BigSeq(BigSeq.concat(vals, this.left), this.middle, this.right, null);
        }
        if (a >= 4 && 8 <= b && b <= 15) {
            return new BigSeq(vals, this.middle.cons(new LeafNode(this.left)), this.right, null);
        }
        int mid = n / 2;
        int move = mid - a;
        Item[] newLeft = BigSeq.slice(vals, 0, mid);
        System.arraycopy(this.left, 0, newLeft, a, move);
        LeafNode leaf = new LeafNode(BigSeq.slice(this.left, move, b));
        return new BigSeq(newLeft, this.middle.cons(leaf), this.right, null);
    }
}

