/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class GDt
extends ADate {
    private static final Type[] TYPES = new Type[]{AtomType.YEA, AtomType.YMO, AtomType.MON, AtomType.MDA, AtomType.DAY};
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))(([-+])(\\d{2}):(\\d{2})|Z)?"), Pattern.compile("(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))-(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?"), Pattern.compile("--(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?"), Pattern.compile("--(\\d{2})-(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?"), Pattern.compile("---(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?")};
    private static final String[] EXAMPLES = new String[]{"2000", "2000-12", "--12", "--12-31", "---31"};
    private static final int[] ZONES = new int[]{3, 4, 2, 3, 2};

    public GDt(ADate date, Type type) {
        super(type, date);
        if (type != AtomType.YEA && type != AtomType.YMO) {
            this.yea = Long.MAX_VALUE;
        }
        if (type != AtomType.MON && type != AtomType.YMO && type != AtomType.MDA) {
            this.mon = (byte)-1;
        }
        if (type != AtomType.DAY && type != AtomType.MDA) {
            this.day = (byte)-1;
        }
        this.hou = (byte)-1;
        this.min = (byte)-1;
        this.sec = null;
    }

    public GDt(byte[] date, Type type, InputInfo info) throws QueryException {
        super(type);
        String dt = Token.string(date).trim();
        int i = GDt.type(type);
        Matcher mt = PATTERNS[i].matcher(dt);
        if (!mt.matches()) {
            throw this.dateError(date, EXAMPLES[i], info);
        }
        if (i < 2) {
            this.yea = this.toLong(mt.group(1), false, info);
            if (this.yea < 0L) {
                ++this.yea;
            }
            if (this.yea < -25252734927766554L || this.yea >= 25252734927766554L) {
                throw QueryError.DATERANGE_X_X.get(info, type, QueryError.chop(date, info));
            }
        }
        if (i > 0 && i < 4) {
            this.mon = (byte)(Strings.toLong(mt.group(i == 1 ? 3 : 1)) - 1L);
            if (this.mon < 0 || this.mon > 11) {
                throw this.dateError(date, EXAMPLES[i], info);
            }
        }
        if (i > 2) {
            this.day = (byte)(Strings.toLong(mt.group(i == 3 ? 2 : 1)) - 1L);
            int m = Math.max(this.mon, 0);
            if (this.day < 0 || this.day >= DAYS[m] + (m == 1 ? (byte)1 : 0)) {
                throw this.dateError(date, EXAMPLES[i], info);
            }
        }
        this.zone(mt, ZONES[i], date, info);
    }

    private static int type(Type type) {
        int tl = TYPES.length;
        int t = 0;
        while (t < tl) {
            if (TYPES[t] == type) {
                return t;
            }
            ++t;
        }
        throw Util.notExpected();
    }

    @Override
    public void timeZone(DTDur zone, boolean d, InputInfo info) {
        throw Util.notExpected();
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        throw QueryError.diffError(item, this, info);
    }

    @Override
    public byte[] string(InputInfo info) {
        TokenBuilder tb = new TokenBuilder();
        if (this.yea == Long.MAX_VALUE) {
            tb.add(45);
        } else {
            if (this.yea <= 0L) {
                tb.add(45);
            }
            GDt.prefix(tb, Math.abs(this.yea()), 4);
        }
        if (this.mon >= 0 || this.day >= 0) {
            tb.add(45);
        }
        if (this.mon >= 0) {
            GDt.prefix(tb, this.mon + 1, 2);
        }
        if (this.day >= 0) {
            tb.add(45);
        }
        if (this.day >= 0) {
            GDt.prefix(tb, this.day + 1, 2);
        }
        this.zone(tb);
        return tb.finish();
    }
}

