/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Flt
extends ANum {
    public static final Flt NAN = new Flt(Float.NaN);
    public static final Flt ZERO = new Flt(0.0f);
    public static final Flt ONE = new Flt(1.0f);
    private final float value;

    private Flt(float value) {
        super(AtomType.FLT);
        this.value = value;
    }

    public static Flt get(float value) {
        return value == 0.0f && Float.floatToRawIntBits(value) == 0 ? ZERO : (value == 1.0f ? ONE : (Float.isNaN(value) ? NAN : new Flt(value)));
    }

    @Override
    protected byte[] string() {
        return Token.token(this.value);
    }

    @Override
    public boolean bool(InputInfo info) {
        return !Float.isNaN(this.value) && this.value != 0.0f;
    }

    @Override
    public long itr() {
        return (long)this.value;
    }

    @Override
    public float flt() {
        return this.value;
    }

    @Override
    public double dbl() {
        return this.value;
    }

    @Override
    public BigDecimal dec(InputInfo info) throws QueryException {
        if (Float.isNaN(this.value) || Float.isInfinite(this.value)) {
            throw QueryError.valueError(AtomType.DEC, this.string(), info);
        }
        return new BigDecimal(this.value);
    }

    @Override
    public Flt abs() {
        return (double)this.value > 0.0 || 1.0f / this.value > 0.0f ? this : Flt.get(-this.value);
    }

    @Override
    public Flt ceiling() {
        float v = (float)Math.ceil(this.value);
        return v == this.value ? this : Flt.get(v);
    }

    @Override
    public Flt floor() {
        float v = (float)Math.floor(this.value);
        return v == this.value ? this : Flt.get(v);
    }

    @Override
    public Flt round(int scale, boolean even) {
        float v = Dbl.get(this.value).round(scale, even).flt();
        return this.value == v ? this : Flt.get(v);
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
        return item.type == AtomType.DBL ? item.eq(this, coll, sc, info) : this.value == item.flt(info);
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        float n = item.flt(info);
        return Float.isNaN(n) || Float.isNaN(this.value) ? Integer.MIN_VALUE : (this.value < n ? -1 : (this.value > n ? 1 : 0));
    }

    @Override
    public Float toJava() {
        return Float.valueOf(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Flt && this.value == ((Flt)obj).value || this == NAN && obj == NAN;
    }

    public static float parse(Item item, InputInfo info) throws QueryException {
        byte[] value = item.string(info);
        try {
            return Float.parseFloat(Token.string(value));
        }
        catch (NumberFormatException ex) {
            byte[] v = Token.trim(value);
            if (Token.eq(v, Token.INF)) {
                return Float.POSITIVE_INFINITY;
            }
            if (Token.eq(v, Token.NINF)) {
                return Float.NEGATIVE_INFINITY;
            }
            throw AtomType.FLT.castError(item, info);
        }
    }
}

