/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.ArrayList;
import org.basex.query.util.ft.FTPos;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;

final class DataFTBuilder {
    private static final byte[] DOTS = Token.token("...");
    private final FTPosData pos;
    private final int len;
    private final int name;

    DataFTBuilder(FTPosData pos, int len, int name) {
        this.pos = pos;
        this.len = len;
        this.name = name;
    }

    int name() {
        return this.name;
    }

    ArrayList<DataFTMarker> build(ANode node) {
        int ln;
        if (!(node instanceof DBNode)) {
            return null;
        }
        DBNode dbnode = (DBNode)node;
        FTPos ftp = this.pos.get(dbnode.data(), dbnode.pre());
        if (ftp == null) {
            return null;
        }
        ArrayList<DataFTMarker> marks = new ArrayList<DataFTMarker>();
        TokenBuilder token = new TokenBuilder();
        byte[] string = node.string();
        FTLexer lexer = new FTLexer().original().init(string);
        while (lexer.hasNext()) {
            FTSpan span = lexer.next();
            if (!span.del && ftp.contains(span.pos)) {
                if (!token.isEmpty()) {
                    marks.add(new DataFTMarker(token.next(), false));
                }
                marks.add(new DataFTMarker(span.text, true));
                continue;
            }
            token.add(span.text);
        }
        if (!token.isEmpty()) {
            marks.add(new DataFTMarker(token.finish(), false));
        }
        if ((ln = -this.len + string.length) > 0) {
            DataFTMarker dm;
            int l;
            int lastl;
            int ms = marks.size();
            DataFTMarker first = marks.get(0);
            int firstl = first.mark ? 0 : first.token.length;
            DataFTMarker last = marks.get(ms - 1);
            int n = lastl = last.mark ? 0 : last.token.length;
            if (!first.mark && (l = Math.min(firstl, (int)((long)ln * (long)firstl / (long)(firstl + lastl)))) > 0) {
                first.token = Token.concat(DOTS, Token.subtoken(first.token, l));
                ln -= l;
            }
            if (!last.mark && ln > 0) {
                l = Math.min(lastl, ln);
                last.token = Token.concat(Token.subtoken(last.token, 0, lastl - l), DOTS);
                ln -= l;
            }
            int m = ms - 2;
            while (m > 0 && ln > 0) {
                dm = marks.get(m);
                if (!dm.mark) {
                    int txtl = dm.token.length;
                    int l2 = Math.min(txtl, ln);
                    dm.token = Token.concat(Token.subtoken(dm.token, 0, (txtl - l2) / 2), DOTS, Token.subtoken(dm.token, (txtl + l2) / 2));
                    ln -= l2;
                }
                --m;
            }
            m = ms - 1;
            while (m >= 0 && ln > 0) {
                dm = marks.get(m);
                if (dm.mark) {
                    ln -= marks.remove((int)m).token.length;
                }
                --m;
            }
            m = marks.size() - 2;
            while (m >= 0) {
                DataFTMarker dm1 = marks.get(m);
                DataFTMarker dm2 = marks.get(m + 1);
                if (!dm1.mark && !dm2.mark) {
                    if (!Token.eq(dm1.token, DOTS) || !Token.eq(dm2.token, DOTS)) {
                        dm1.token = Token.concat(dm1.token, dm2.token);
                    }
                    marks.remove(m + 1);
                }
                --m;
            }
        }
        return marks;
    }

    static final class DataFTMarker {
        byte[] token;
        final boolean mark;

        private DataFTMarker(byte[] token, boolean mark) {
            this.token = token;
            this.mark = mark;
        }

        public String toString() {
            return String.valueOf(Token.string(this.token)) + " (" + this.mark + ')';
        }
    }
}

