/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.validate;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOStream;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.validate.ErrorInfo;
import org.basex.query.func.validate.ValidateFn;
import org.basex.query.func.validate.Validation;
import org.basex.query.func.validate.ValidationHandler;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.xml.sax.SAXException;

public class ValidateXsd
extends ValidateFn {
    private static final String SCHEMA_FACTORY_CP = "javax.xml.validation.SchemaFactory";
    private static final String XSD10_URI = "http://www.w3.org/XML/XMLSchema/v1.0";
    private static final String XSD11_URI = "http://www.w3.org/XML/XMLSchema/v1.1";
    private static final String SAXON_CP = "com.saxonica.ee.jaxp.SchemaFactoryImpl";
    private static final String XERCES_CP = "org.apache.xerces.jaxp.validation.XMLSchemaFactory";
    private static final String XERCES11_CP = "org.apache.xerces.jaxp.validation.XMLSchema11Factory";
    private static final String SAXON_VERSION_URI = "http://saxon.sf.net/feature/xsd-version";
    private static final String VERSION_10 = "1.0";
    private static final String VERSION_11 = "1.1";

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.check(qc);
    }

    @Override
    public ArrayList<ErrorInfo> errors(final QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        return this.process(new Validation(){

            @Override
            void process(ValidationHandler handler) throws IOException, SAXException, QueryException {
                String uri;
                IO in = ValidateXsd.this.read(ValidateXsd.this.toNodeOrAtomItem(0, qc), null);
                Item schema = ValidateXsd.this.toNodeOrAtomItem(1, qc);
                String version = ValidateXsd.this.exprs.length > 2 ? Token.string(ValidateXsd.this.toToken(ValidateXsd.this.exprs[2], qc)) : null;
                boolean xsd11 = ValidateXsd.VERSION_11.equals(version);
                String cp = null;
                if (Reflect.find(ValidateXsd.XERCES11_CP) != null) {
                    cp = xsd11 ? ValidateXsd.XERCES11_CP : ValidateXsd.XERCES_CP;
                } else if (Reflect.find(ValidateXsd.SAXON_CP) != null) {
                    cp = ValidateXsd.SAXON_CP;
                }
                if (version == null || version.equals(ValidateXsd.VERSION_10)) {
                    uri = cp == null ? "http://www.w3.org/2001/XMLSchema" : ValidateXsd.XSD10_URI;
                } else if (xsd11 && cp != null) {
                    uri = ValidateXsd.XSD11_URI;
                } else {
                    throw QueryError.VALIDATE_VERSION_X.get(ValidateXsd.this.info, version);
                }
                if (cp != null) {
                    System.setProperty("javax.xml.validation.SchemaFactory:" + uri, cp);
                }
                SchemaFactory sf = SchemaFactory.newInstance(uri);
                if (ValidateXsd.SAXON_CP.equals(cp)) {
                    sf.setProperty(ValidateXsd.SAXON_VERSION_URI, xsd11 ? ValidateXsd.VERSION_11 : ValidateXsd.VERSION_10);
                }
                Schema s = schema == null ? sf.newSchema() : sf.newSchema(new URL(this.prepare(ValidateXsd.this.read(schema, null), handler).url()));
                Validator v = s.newValidator();
                v.setErrorHandler(handler);
                v.validate(in instanceof IOContent || in instanceof IOStream ? new StreamSource(in.inputStream()) : new StreamSource(in.url()));
            }
        });
    }
}

