/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.jobs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.Context;
import org.basex.core.jobs.Jobs;
import org.basex.core.jobs.JobsOptions;
import org.basex.core.jobs.QueryJob;
import org.basex.core.jobs.QueryJobSpec;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public class JobsEval
extends StandardFunc {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.eval(qc, Token.string(this.toToken(this.exprs[0], qc)), null);
    }

    final Str eval(QueryContext qc, String query, String path) throws QueryException {
        boolean service;
        this.checkAdmin(qc);
        HashMap<String, Value> bindings = this.toBindings(1, qc);
        JobsOptions opts = this.toOptions(2, new JobsOptions(), qc);
        Context ctx = qc.context;
        for (Map.Entry<String, Value> it : bindings.entrySet()) {
            bindings.put(it.getKey(), QueryJob.copy(it.getValue().iter(), ctx, qc));
        }
        if (ctx.jobs.active.size() >= 1000) {
            throw QueryError.JOBS_OVERFLOW.get(this.info, new Object[0]);
        }
        String base = opts.get(JobsOptions.BASE_URI);
        String uri = base != null ? base : (path != null ? path : Token.string(this.sc.baseURI().string()));
        opts.set(JobsOptions.BASE_URI, uri);
        boolean bl = service = opts.contains(JobsOptions.SERVICE) && opts.get(JobsOptions.SERVICE) != false;
        if (service) {
            if (!bindings.isEmpty()) {
                throw QueryError.JOBS_SERVICE.get(this.info, new Object[0]);
            }
            opts.put(JobsOptions.SERVICE, null);
        }
        QueryJobSpec spec = new QueryJobSpec(opts, bindings, query);
        QueryJob job = new QueryJob(spec, this.info, qc.context);
        if (service) {
            if (!bindings.isEmpty()) {
                throw QueryError.JOBS_SERVICE.get(this.info, new Object[0]);
            }
            try {
                Jobs jobs = new Jobs(qc.context);
                jobs.add(spec);
                jobs.write();
            }
            catch (IOException ex) {
                throw QueryError.JOBS_SERVICE_X_X.get(this.info, ex);
            }
        }
        return Str.get(job.jc().id());
    }
}

