/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.ft.FtAccess;
import org.basex.query.func.ft.FtTokenizeOptions;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTDiacritics;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Language;
import org.basex.util.list.TokenList;

public class FtTokenize
extends FtAccess {
    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return StrSeq.get(this.tokens(qc, false));
    }

    protected final TokenList tokens(QueryContext qc, boolean all) throws QueryException {
        FTCase cs;
        String ln;
        Boolean st;
        byte[] token = this.toToken(this.exprs[0], qc);
        FtTokenizeOptions opts = this.toOptions(1, new FtTokenizeOptions(), qc);
        FTOpt opt = new FTOpt().assign(qc.ftOpt());
        FTDiacritics dc = opts.get(FtTokenizeOptions.DIACRITICS);
        if (dc != null) {
            opt.set(FTFlag.DC, dc == FTDiacritics.SENSITIVE);
        }
        if ((st = opts.get(FtTokenizeOptions.STEMMING)) != null) {
            opt.set(FTFlag.ST, st);
        }
        if ((ln = opts.get(FtTokenizeOptions.LANGUAGE)) != null) {
            opt.ln = Language.get(ln);
        }
        if ((cs = opts.get(FtTokenizeOptions.CASE)) != null) {
            opt.cs = cs;
        }
        TokenList tl = new TokenList();
        FTLexer lexer = new FTLexer(opt).init(token);
        if (all) {
            lexer.all();
        }
        while (lexer.hasNext()) {
            tl.add(lexer.nextToken());
        }
        return tl;
    }
}

