/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.ArrayList;
import org.basex.index.path.PathNode;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.collation.CollationItemSet;
import org.basex.query.util.hash.HashItemSet;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;

public final class FnDistinctValues
extends StandardFunc {
    private boolean simple;

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        Collation coll = this.toCollation(1, qc);
        Expr expr = this.exprs[0];
        final Iter iter = expr.atomIter(qc, this.info);
        if (this.simple || expr instanceof RangeSeq || expr instanceof Range) {
            return iter;
        }
        final ItemSet set = coll == null ? new HashItemSet(false) : new CollationItemSet(coll);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(iter)) != null) {
                    if (!set.add(item, FnDistinctValues.this.info)) continue;
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item item;
        Collation coll = this.toCollation(1, qc);
        Expr expr = this.exprs[0];
        if (this.simple || expr instanceof RangeSeq || expr instanceof Range) {
            return expr.atomValue(qc, this.info);
        }
        ItemSet set = coll == null ? new HashItemSet(false) : new CollationItemSet(coll);
        Iter iter = expr.atomIter(qc, this.info);
        ValueBuilder vb = new ValueBuilder(qc);
        while ((item = qc.next(iter)) != null) {
            if (!set.add(item, this.info)) continue;
            vb.add(item);
        }
        return vb.value();
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr = this.exprs[0];
        if (expr instanceof RangeSeq) {
            return expr;
        }
        if (expr instanceof SingletonSeq) {
            this.exprs[0] = expr = ((SingletonSeq)expr).value;
        }
        SeqType st = expr.seqType();
        AtomType type = st.type.atomic();
        if (type != null) {
            this.exprType.assign(type);
            this.simple = st.zeroOrOne();
        }
        return this.optStats(expr, cc);
    }

    private Expr optStats(Expr expr, CompileContext cc) throws QueryException {
        if (this.exprs.length > 1 || !(expr instanceof AxisPath)) {
            return this;
        }
        ArrayList<PathNode> nodes = ((AxisPath)expr).pathNodes(cc);
        if (nodes == null) {
            return this;
        }
        ValueBuilder vb = new ValueBuilder(cc.qc);
        HashItemSet set = new HashItemSet(false);
        for (PathNode pn : nodes) {
            if (pn.kind == 1) {
                if (!pn.stats.isLeaf()) {
                    return this;
                }
                PathNode[] pathNodeArray = pn.children;
                int n = pn.children.length;
                int n2 = 0;
                while (n2 < n) {
                    PathNode n3 = pathNodeArray[n2];
                    if (n3.kind == 2) {
                        pn = n3;
                    }
                    ++n2;
                }
            }
            if (pn.kind != 2 && pn.kind != 3) {
                return this;
            }
            if (!StatsType.isCategory(pn.stats.type)) {
                return this;
            }
            for (byte[] c : pn.stats.values) {
                Atm it = new Atm(c);
                if (!set.add(it, this.info)) continue;
                vb.add(it);
            }
        }
        return vb.value();
    }
}

