/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;

abstract class FileFn
extends StandardFunc {
    FileFn() {
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        this.checkAdmin(qc);
        try {
            return this.item(qc);
        }
        catch (NoSuchFileException ex) {
            throw QueryError.FILE_NOT_FOUND_X.get(this.info, ex);
        }
        catch (AccessDeniedException ex) {
            throw QueryError.FILE_IE_ERROR_ACCESS_X.get(this.info, ex);
        }
        catch (FileAlreadyExistsException ex) {
            throw QueryError.FILE_EXISTS_X.get(this.info, ex);
        }
        catch (DirectoryNotEmptyException ex) {
            throw QueryError.FILE_ID_DIR2_X.get(this.info, ex);
        }
        catch (IOException ex) {
            throw QueryError.FILE_IO_ERROR_X.get(this.info, ex);
        }
    }

    public Item item(QueryContext qc) throws QueryException, IOException {
        return super.item(qc, null);
    }

    final Path checkParentDir(Path path) throws QueryException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw QueryError.FILE_IS_DIR_X.get(this.info, path.toAbsolutePath());
        }
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            throw QueryError.FILE_NO_DIR_X.get(this.info, parent.toAbsolutePath());
        }
        return path;
    }

    final boolean optionalBool(int i, QueryContext qc) throws QueryException {
        return i < this.exprs.length && this.toBoolean(this.exprs[i], qc);
    }

    static Str get(Path path, boolean dir) {
        String string = path.toString();
        return Str.get(dir && !string.endsWith(File.separator) ? String.valueOf(string) + File.separator : string);
    }

    static Path absolute(Path path) {
        return path.toAbsolutePath().normalize();
    }
}

