/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.Databases;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccess;
import org.basex.query.up.primitives.name.DBRestore;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class DbRestore
extends DbAccess {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String name = Token.string(this.toToken(this.exprs[0], qc));
        if (!Databases.validName(name)) {
            throw QueryError.DB_NAME_X.get(this.info, name);
        }
        StringList backups = qc.context.databases.backups(name);
        if (backups.isEmpty()) {
            throw QueryError.DB_NOBACKUP_X.get(this.info, name);
        }
        String backup = (String)backups.get(0);
        String db = Databases.name(backup);
        qc.updates().add(new DBRestore(db, backup, qc, this.info), qc);
        return null;
    }
}

