/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.cmd.Rename;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccess;
import org.basex.query.up.Updates;
import org.basex.query.up.primitives.db.DBDelete;
import org.basex.query.up.primitives.db.DBRename;
import org.basex.query.up.primitives.node.ReplaceValue;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class DbRename
extends DbAccess {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Data data = this.checkData(qc);
        String source = this.path(1, qc);
        String target = this.path(2, qc);
        Updates updates = qc.updates();
        IntList il = data.resources.docs(source);
        int is = il.size();
        int i = 0;
        while (i < is) {
            int pre = il.get(i);
            String trg = Rename.target(data, pre, source, target);
            if (trg.isEmpty() || trg.endsWith("/") || trg.endsWith(".")) {
                throw QueryError.DB_PATH_X.get(this.info, trg);
            }
            updates.add(new ReplaceValue(pre, data, this.info, Token.token(trg)), qc);
            ++i;
        }
        if (!data.inMemory()) {
            IOFile src = data.meta.binary(source);
            IOFile trg = data.meta.binary(target);
            if (src == null || trg == null) {
                throw QueryError.DB_PATH_X.get(this.info, src);
            }
            if (!src.eq(trg)) {
                this.rename(data, src, trg, qc);
                updates.add(new DBDelete(data, source, this.info), qc);
            }
        }
        return null;
    }

    private void rename(Data data, IOFile src, IOFile trg, QueryContext qc) throws QueryException {
        if (src.isDir()) {
            if (trg.exists() && !trg.isDir()) {
                throw QueryError.DB_PATH_X.get(this.info, src);
            }
            IOFile[] iOFileArray = src.children();
            int n = iOFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOFile f = iOFileArray[n2];
                this.rename(data, f, new IOFile(trg, f.name()), qc);
                ++n2;
            }
        } else if (src.exists()) {
            if (trg.isDir()) {
                throw QueryError.DB_PATH_X.get(this.info, src);
            }
            qc.updates().add(new DBRename(data, src.path(), trg.path(), this.info), qc);
        }
    }
}

