/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.crypto;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerMode;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.crypto.MyKeySelector;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class DigitalSignature {
    private static final TokenMap CANONICALS = new TokenMap();
    private static final TokenMap DIGESTS = new TokenMap();
    private static final TokenMap SIGNATURES = new TokenMap();
    private static final TokenSet TYPES = new TokenSet();
    private static final byte[] DEFC = Token.token("inclusive-with-comments");
    private static final byte[] DEFD = Token.token("sha1");
    private static final byte[] DEFS = Token.token("rsa_sha1");
    private static final byte[] DEFT = Token.token("enveloped");
    private static final byte[] ENVT = Token.token("enveloping");
    private final InputInfo info;

    static {
        CANONICALS.put("inclusive-with-comments", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        CANONICALS.put("exclusive-with-comments", "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        CANONICALS.put("inclusive", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        CANONICALS.put("exclusive", "http://www.w3.org/2001/10/xml-exc-c14n#");
        DIGESTS.put("sha1", "http://www.w3.org/2000/09/xmldsig#sha1");
        DIGESTS.put("sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
        DIGESTS.put("sha512", "http://www.w3.org/2001/04/xmlenc#sha512");
        SIGNATURES.put("rsa_sha1", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        SIGNATURES.put("dsa_sha1", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        TYPES.add(DEFT);
        TYPES.add(ENVT);
    }

    DigitalSignature(InputInfo info) {
        this.info = info;
    }

    Item generateSignature(ANode node, byte[] can, byte[] dig, byte[] sig, byte[] ns, byte[] tp, byte[] expr, ANode cert, QueryContext qc, InputInfo ii) throws QueryException {
        Item signedNode;
        byte[] b = can;
        if (b.length == 0) {
            b = DEFC;
        }
        if ((b = CANONICALS.get(Token.lc(b))) == null) {
            throw QueryError.CX_CANINV.get(this.info, new Object[]{can});
        }
        String canonicalization = Token.string(b);
        b = dig;
        if (b.length == 0) {
            b = DEFD;
        }
        if ((b = DIGESTS.get(Token.lc(b))) == null) {
            throw QueryError.CX_DIGINV.get(this.info, new Object[]{dig});
        }
        String digest = Token.string(b);
        b = sig;
        if (b.length == 0) {
            b = DEFS;
        }
        byte[] tsig = b;
        if ((b = SIGNATURES.get(Token.lc(b))) == null) {
            throw QueryError.CX_SIGINV.get(this.info, new Object[]{sig});
        }
        String signature = Token.string(b);
        String keytype = Token.string(tsig).substring(0, 3);
        b = tp;
        if (b.length == 0) {
            b = DEFT;
        }
        if (!TYPES.contains(Token.lc(b))) {
            throw QueryError.CX_SIGTYPINV.get(this.info, new Object[]{tp});
        }
        byte[] type = b;
        try {
            XMLSignature xmlSig;
            DOMSignContext signContext;
            List<Transform> tfList;
            KeyInfo ki;
            PrivateKey pk;
            XMLSignatureFactory fac;
            block57: {
                block55: {
                    KeyStore ks;
                    fac = XMLSignatureFactory.getInstance("DOM");
                    if (cert == null) break block55;
                    Document ceDOM = DigitalSignature.toDOMNode(cert);
                    if (!"digital-certificate".equals(ceDOM.getDocumentElement().getNodeName())) {
                        throw QueryError.CX_INVNM.get(this.info, ceDOM);
                    }
                    NodeList ceChildren = ceDOM.getDocumentElement().getChildNodes();
                    int s = ceChildren.getLength();
                    int ci = 0;
                    String ksURI = null;
                    String pkPW = null;
                    String kAlias = null;
                    String ksPW = null;
                    String ksTY = null;
                    while (ci < s) {
                        Node cn = ceChildren.item(ci++);
                        switch (cn.getNodeName()) {
                            case "keystore-type": {
                                ksTY = cn.getTextContent();
                                break;
                            }
                            case "keystore-password": {
                                ksPW = cn.getTextContent();
                                break;
                            }
                            case "key-alias": {
                                kAlias = cn.getTextContent();
                                break;
                            }
                            case "private-key-password": {
                                pkPW = cn.getTextContent();
                                break;
                            }
                            case "keystore-uri": {
                                ksURI = cn.getTextContent();
                            }
                        }
                    }
                    try {
                        ks = KeyStore.getInstance(ksTY);
                    }
                    catch (KeyStoreException ex) {
                        throw QueryError.CX_KSNULL_X.get(this.info, ex);
                    }
                    Throwable ex = null;
                    Object var33_44 = null;
                    try (FileInputStream fis = new FileInputStream(ksURI);){
                        ks.load(fis, ksPW.toCharArray());
                    }
                    catch (Throwable throwable) {
                        if (ex == null) {
                            ex = throwable;
                        } else if (ex != throwable) {
                            ex.addSuppressed(throwable);
                        }
                        throw ex;
                    }
                    pk = (PrivateKey)ks.getKey(kAlias, pkPW.toCharArray());
                    X509Certificate x509ce = (X509Certificate)ks.getCertificate(kAlias);
                    if (x509ce == null) {
                        throw QueryError.CX_ALINV_X.get(this.info, kAlias);
                    }
                    PublicKey puk = x509ce.getPublicKey();
                    KeyInfoFactory kifactory = fac.getKeyInfoFactory();
                    KeyValue keyValue = kifactory.newKeyValue(puk);
                    ArrayList<XMLStructure> kiCont = new ArrayList<XMLStructure>();
                    kiCont.add(keyValue);
                    ArrayList<Object> x509Content = new ArrayList<Object>();
                    X509IssuerSerial issuer = kifactory.newX509IssuerSerial(x509ce.getIssuerX500Principal().getName(), x509ce.getSerialNumber());
                    x509Content.add(x509ce.getSubjectX500Principal().getName());
                    x509Content.add(issuer);
                    x509Content.add(x509ce);
                    X509Data x509Data = kifactory.newX509Data(x509Content);
                    kiCont.add(x509Data);
                    ki = kifactory.newKeyInfo(kiCont);
                    break block57;
                }
                KeyPairGenerator gen = KeyPairGenerator.getInstance(keytype);
                gen.initialize(512);
                KeyPair kp = gen.generateKeyPair();
                KeyInfoFactory kif = fac.getKeyInfoFactory();
                KeyValue kv = kif.newKeyValue(kp.getPublic());
                ki = kif.newKeyInfo(Collections.singletonList(kv));
                pk = kp.getPrivate();
            }
            Document inputNode = DigitalSignature.toDOMNode(node);
            if (expr.length > 0) {
                XPathFactory xpf = XPathFactory.newInstance();
                XPathExpression xExpr = xpf.newXPath().compile(Token.string(expr));
                NodeList xRes = (NodeList)xExpr.evaluate(inputNode, XPathConstants.NODESET);
                if (xRes.getLength() < 1) {
                    throw QueryError.CX_XPINV.get(this.info, new Object[]{expr});
                }
                tfList = new ArrayList<Transform>(2);
                tfList.add(fac.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec(Token.string(expr))));
                tfList.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            } else {
                tfList = Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            }
            Reference ref = fac.newReference("", fac.newDigestMethod(digest, null), tfList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod(canonicalization, (C14NMethodParameterSpec)null), fac.newSignatureMethod(signature, null), Collections.singletonList(ref));
            if (Token.eq(type, DEFT)) {
                signContext = new DOMSignContext(pk, (Node)inputNode.getDocumentElement());
                xmlSig = fac.newXMLSignature(si, ki);
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DOMStructure cont = new DOMStructure(inputNode.getDocumentElement());
                XMLObject obj = fac.newXMLObject(Collections.singletonList(cont), "", null, null);
                xmlSig = fac.newXMLSignature(si, ki, Collections.singletonList(obj), null, null);
                signContext = new DOMSignContext(pk, (Node)inputNode);
            }
            if (ns.length > 0) {
                signContext.setDefaultNamespacePrefix(Token.string(ns));
            }
            xmlSig.sign(signContext);
            signedNode = NodeType.DOC.cast(inputNode, qc, null, ii);
        }
        catch (XPathExpressionException e) {
            throw QueryError.CX_XPINV.get(this.info, e);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw QueryError.CX_IOEXC.get(this.info, e);
        }
        catch (KeyStoreException e) {
            throw QueryError.CX_KSEXC.get(this.info, e);
        }
        catch (MarshalException | XMLSignatureException e) {
            throw QueryError.CX_SIGEXC.get(this.info, e);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertificateException e) {
            throw QueryError.CX_ALGEXC.get(this.info, e);
        }
        catch (KeyException | UnrecoverableKeyException e) {
            throw QueryError.CX_NOKEY.get(this.info, e);
        }
        return signedNode;
    }

    Item validateSignature(ANode node) throws QueryException {
        try {
            Document doc = DigitalSignature.toDOMNode(node);
            DOMValidateContext valContext = new DOMValidateContext(new MyKeySelector(), (Node)doc);
            NodeList signl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (signl.getLength() < 1) {
                throw QueryError.CX_NOSIG.get(this.info, node);
            }
            valContext.setNode(signl.item(0));
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            return Bln.get(signature.validate(valContext));
        }
        catch (IOException | XMLSignatureException | ParserConfigurationException | SAXException e) {
            throw QueryError.CX_IOEXC.get(this.info, e);
        }
        catch (MarshalException e) {
            throw QueryError.CX_SIGEXC.get(this.info, e);
        }
    }

    private static byte[] nodeToBytes(ANode node) throws IOException {
        ArrayOutput ao = new ArrayOutput();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Serializer ser = Serializer.get(ao, SerializerMode.NOINDENT.get());){
            ser.serialize(node);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ao.finish();
    }

    private static Document toDOMNode(ANode node) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(DigitalSignature.nodeToBytes(node)));
    }
}

