/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.convert;

import java.math.BigInteger;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public final class ConvertIntegerToBase
extends StandardFunc {
    private static final BigInteger MAX_ULONG = BigInteger.ONE.shiftLeft(64);
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        long num = this.toLong(this.exprs[0], qc);
        long base = this.toLong(this.exprs[1], qc);
        if (base < 2L || base > 36L) {
            throw QueryError.CONVERT_BASE_X.get(this.info, base);
        }
        int i = 1;
        int p = 2;
        while (i < 6) {
            if (base == (long)p) {
                return ConvertIntegerToBase.toBaseFast(num, i);
            }
            ++i;
            p <<= 1;
        }
        ByteList tb = new ByteList();
        long n = num;
        if (n < 0L) {
            BigInteger[] dr = BigInteger.valueOf(n).add(MAX_ULONG).divideAndRemainder(BigInteger.valueOf(base));
            n = dr[0].longValue();
            tb.add(DIGITS[dr[1].intValue()]);
        } else {
            tb.add(DIGITS[(int)(n % base)]);
            n /= base;
        }
        while (n != 0L) {
            tb.add(DIGITS[(int)(n % base)]);
            n /= base;
        }
        byte[] res = tb.finish();
        Array.reverse(res);
        return Str.get(res);
    }

    private static Str toBaseFast(long num, int shift) {
        byte[] bytes = new byte[(64 + shift - 1) / shift];
        int mask = (1 << shift) - 1;
        long n = num;
        int pos = bytes.length;
        do {
            bytes[--pos] = DIGITS[(int)(n & (long)mask)];
        } while ((n >>>= shift) != 0L);
        return Str.get(Token.substring(bytes, pos));
    }
}

