/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.ArchiveText;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;

public final class ArchiveEntries
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        B64 archive = this.toB64(this.exprs[0], qc, false);
        ValueBuilder vb = new ValueBuilder(qc);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);){
                while (in.more()) {
                    ZipEntry ze = in.entry();
                    if (ze.isDirectory()) continue;
                    FElem elem = new FElem(ArchiveText.Q_ENTRY).declareNS();
                    long size = ze.getSize();
                    if (size != -1L) {
                        elem.add(ArchiveText.SIZE, Token.token(size));
                    }
                    if ((size = ze.getTime()) != -1L) {
                        elem.add(ArchiveText.LAST_MODIFIED, Dtm.get(size).string(this.info));
                    }
                    if ((size = ze.getCompressedSize()) != -1L) {
                        elem.add(ArchiveText.COMPRESSED_SIZE, Token.token(size));
                    }
                    elem.add(ze.getName());
                    vb.add(elem);
                }
                return vb.value();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
    }
}

