/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import org.basex.core.MainOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.FuncCall;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.StaticFuncs;
import org.basex.query.func.XQFunction;
import org.basex.query.scope.Scope;
import org.basex.query.scope.StaticDecl;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class StaticFunc
extends StaticDecl
implements XQFunction {
    public final Var[] params;
    final boolean updating;
    private final EnumMap<Flag, Boolean> map = new EnumMap(Flag.class);
    private boolean compiling;

    StaticFunc(AnnList anns, QNm name, Var[] params, SeqType type, Expr expr, String doc, VarScope vs, InputInfo info) {
        super(anns, name, type, vs, doc, info);
        this.params = params;
        this.expr = expr;
        this.updating = anns.contains(Annotation.UPDATING);
    }

    @Override
    public void comp(CompileContext cc) {
        block9: {
            if (this.compiled || this.expr == null) {
                return;
            }
            this.compiled = true;
            this.compiling = true;
            cc.pushFocus(null);
            cc.pushScope(this.vs);
            try {
                try {
                    this.expr = this.expr.compile(cc);
                    if (this.declType != null) {
                        Type type = this.declType.type;
                        if (this.declType.eq(this.expr.seqType()) && (type == AtomType.BLN || type == AtomType.FLT || type == AtomType.DBL || type == AtomType.QNM || type == AtomType.URI)) {
                            cc.info("remove type check: %", this);
                        } else {
                            this.expr = new TypeCheck(this.sc, this.info, this.expr, this.declType, true).optimize(cc);
                        }
                    }
                }
                catch (QueryException qe) {
                    this.declType = SeqType.ITEM_ZM;
                    this.expr = cc.error(qe, this.expr);
                    cc.removeScope(this);
                    cc.removeFocus();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                cc.removeScope(this);
                cc.removeFocus();
                throw throwable;
            }
            cc.removeScope(this);
            cc.removeFocus();
        }
        this.expr.markTailCalls(cc);
        this.compiling = false;
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem("name", this.name.string(), "type", this.seqType());
        StaticFunc.addPlan(plan, elem, this.expr);
        int pl = this.params.length;
        int p = 0;
        while (p < pl) {
            elem.add(StaticFunc.planAttr("arg" + p, this.params[p].name.string()));
            ++p;
        }
    }

    private boolean selfRecursive() {
        return !this.expr.accept(new ASTVisitor(){

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                return call.func != StaticFunc.this;
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                return scope.visit(this);
            }
        });
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int pos) {
        return this.params[pos].name;
    }

    @Override
    public FuncType funcType() {
        return FuncType.get(this.anns, this.declType, this.params);
    }

    @Override
    public int stackFrameSize() {
        return this.vs.stackSize();
    }

    @Override
    public AnnList annotations() {
        return this.anns;
    }

    @Override
    public Item invItem(QueryContext qc, InputInfo ii, Value ... arg) throws QueryException {
        QueryFocus qf = qc.focus;
        Value cv = qf.value;
        qf.value = null;
        try {
            int pl = this.params.length;
            int p = 0;
            while (p < pl) {
                qc.set(this.params[p], arg[p]);
                ++p;
            }
            Item item = this.expr.item(qc, this.info);
            return item;
        }
        finally {
            qf.value = cv;
        }
    }

    @Override
    public Value invValue(QueryContext qc, InputInfo ii, Value ... arg) throws QueryException {
        QueryFocus qf = qc.focus;
        Value cv = qf.value;
        qf.value = null;
        try {
            int pl = this.params.length;
            int p = 0;
            while (p < pl) {
                qc.set(this.params[p], arg[p]);
                ++p;
            }
            Value value = this.expr.value(qc);
            return value;
        }
        finally {
            qf.value = cv;
        }
    }

    @Override
    public Value invokeValue(QueryContext qc, InputInfo ii, Value ... arg) throws QueryException {
        return FuncCall.value(this, arg, qc, ii);
    }

    @Override
    public Item invokeItem(QueryContext qc, InputInfo ii, Value ... arg) throws QueryException {
        return FuncCall.item(this, arg, qc, this.info);
    }

    void checkUp() throws QueryException {
        InputInfo ii;
        boolean upd = this.expr.has(Flag.UPD);
        if (upd) {
            this.expr.checkUp();
        }
        InputInfo inputInfo = ii = this.expr instanceof ParseExpr ? ((ParseExpr)this.expr).info : this.info;
        if (this.updating) {
            if (this.declType != null && !this.declType.zero()) {
                throw QueryError.UUPFUNCTYPE.get(this.info, new Object[0]);
            }
            if (!upd && !this.expr.isVacuous()) {
                throw QueryError.UPEXPECTF.get(ii, new Object[0]);
            }
        } else if (upd) {
            throw QueryError.UPNOT_X.get(ii, this.description());
        }
    }

    @Override
    public boolean isVacuousBody() {
        return this.declType != null && this.declType.zero() && !this.has(Flag.UPD);
    }

    boolean has(Flag ... flags) {
        Flag[] flgs = Flag.UPD.remove(flags);
        return flgs.length != 0 && this.check(flgs);
    }

    boolean updating() {
        return this.sc.mixUpdates ? this.check(Flag.UPD) : this.updating;
    }

    private boolean check(Flag ... flags) {
        Flag flag2;
        ArrayList<Flag> flgs = new ArrayList<Flag>();
        Flag[] flagArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            flag2 = flagArray[n2];
            if (!this.map.containsKey((Object)flag2)) {
                this.map.put(flag2, false);
                flgs.add(flag2);
            }
            ++n2;
        }
        for (Flag flag2 : flgs) {
            this.map.put(flag2, this.expr.has(flag2));
        }
        flagArray = flags;
        n = flags.length;
        int n3 = 0;
        while (n3 < n) {
            flag2 = flagArray[n3];
            if (this.map.get((Object)flag2).booleanValue()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        Var[] varArray = this.params;
        int n = this.params.length;
        int n2 = 0;
        while (n2 < n) {
            Var var = varArray[n2];
            if (!visitor.declared(var)) {
                return false;
            }
            ++n2;
        }
        return this.expr == null || this.expr.accept(visitor);
    }

    @Override
    public byte[] id() {
        return StaticFuncs.signature(this.name, this.params.length);
    }

    @Override
    public Expr inlineExpr(Expr[] exprs, CompileContext cc, InputInfo ii) throws QueryException {
        if (!StaticFunc.inline(cc, this.anns, this.expr) || this.has(Flag.CTX) || this.compiling || this.selfRecursive()) {
            return null;
        }
        cc.info("inline %", new Object[]{this.id()});
        LinkedList<Clause> clauses = exprs.length == 0 ? null : new LinkedList<Clause>();
        IntObjMap<Var> vars = new IntObjMap<Var>();
        int pl = this.params.length;
        int p = 0;
        while (p < pl) {
            clauses.add(new Let(cc.copy(this.params[p], vars), exprs[p], false).optimize(cc));
            ++p;
        }
        Expr ex = this.expr.copy(cc, vars);
        return clauses == null ? ex : new GFLWOR(this.info, clauses, ex).optimize(cc);
    }

    public static boolean inline(CompileContext cc, AnnList anns, Expr expr) {
        long limit;
        Ann ann = anns.get(Annotation._BASEX_INLINE);
        if (ann == null) {
            limit = cc.qc.context.options.get(MainOptions.INLINELIMIT).intValue();
        } else {
            Item[] args = ann.args();
            long l = limit = args.length > 0 ? ((ANum)args[0]).itr() : Long.MAX_VALUE;
        }
        return expr instanceof Value || (long)expr.exprSize() < limit;
    }

    @Override
    public String description() {
        return "function declaration";
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder("declare").add(32).addExt(this.anns, new Object[0]);
        tb.add("function").add(32).add(this.name.prefixId());
        tb.add("(").addSep(this.params, ", ").add(")");
        if (this.declType != null) {
            tb.add(" as " + this.declType);
        }
        if (this.expr != null) {
            tb.add(" { ").addExt(this.expr, new Object[0]).add(" }; ");
        } else {
            tb.add(" external; ");
        }
        return tb.toString();
    }
}

