/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.basex.core.users.Perm;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaFunction;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

final class JavaFunc
extends JavaFunction {
    private final Class<?> clazz;
    private final String method;
    private final String[] types;

    JavaFunc(StaticContext sc, InputInfo info, Class<?> clazz, String method, String[] types, Expr[] args) {
        super(sc, info, args, Perm.ADMIN);
        this.clazz = clazz;
        this.method = method;
        this.types = types;
    }

    @Override
    protected Object eval(Value[] args, QueryContext qc) throws QueryException {
        try {
            return this.method.equals("new") ? this.constructor(args) : this.method(args, qc);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof QueryException ? ((QueryException)cause).info(this.info) : QueryError.JAVAERROR_X_X_X.get(this.info, this.name(), JavaFunc.foundArgs(args), cause);
        }
        catch (Throwable ex) {
            throw QueryError.JAVAERROR_X_X_X.get(this.info, this.name(), JavaFunc.foundArgs(args), ex);
        }
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new JavaFunc(this.sc, this.info, this.clazz, this.method, this.types, JavaFunc.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
    }

    private Object constructor(Value[] args) throws Exception {
        Constructor<?> cons = null;
        Object[] cargs = null;
        Constructor<?>[] constructorArray = this.clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] jArgs;
            Constructor<?> c = constructorArray[n2];
            Class<?>[] pTypes = c.getParameterTypes();
            if (JavaFunc.typeMatches(pTypes, this.types) && (jArgs = JavaFunc.javaArgs(pTypes, null, args, true)) != null) {
                if (cons != null) {
                    throw QueryError.JAVACONSAMB_X.get(this.info, String.valueOf(Util.className(this.clazz)) + '#' + pTypes.length);
                }
                cons = c;
                cargs = jArgs;
            }
            ++n2;
        }
        if (cons != null) {
            return cons.newInstance(cargs);
        }
        throw QueryError.WHICHCONSTR_X_X.get(this.info, this.name(), JavaFunc.foundArgs(args));
    }

    private Object method(Value[] args, QueryContext qc) throws Exception {
        try {
            Field field = this.clazz.getField(this.method);
            boolean stat = Modifier.isStatic(field.getModifiers());
            if (args.length == (stat ? 0 : 1)) {
                return field.get(stat ? null : this.instObj(args[0]));
            }
        }
        catch (NoSuchFieldException field) {
            // empty catch block
        }
        Method meth = null;
        Object inst = null;
        Object[] margs = null;
        Method[] methodArray = this.clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean stat;
            Object[] jArgs;
            Class<?>[] pTypes;
            Method m = methodArray[n2];
            if (m.getName().equals(this.method) && JavaFunc.typeMatches(pTypes = m.getParameterTypes(), this.types) && (jArgs = JavaFunc.javaArgs(pTypes, null, args, stat = Modifier.isStatic(m.getModifiers()))) != null) {
                if (meth != null) {
                    throw QueryError.JAVAAMB_X_X_X.get(this.info, this.clazz.getName(), this.method, pTypes.length);
                }
                meth = m;
                margs = jArgs;
                if (!stat && (inst = this.instObj(args[0])) instanceof QueryModule) {
                    QueryModule mod = (QueryModule)inst;
                    mod.staticContext = this.sc;
                    mod.queryContext = qc;
                }
            }
            ++n2;
        }
        if (meth != null) {
            return meth.invoke(inst, margs);
        }
        throw QueryError.WHICHMETHOD_X_X.get(this.info, this.name(), JavaFunc.foundArgs(args));
    }

    private Object instObj(Value value) throws QueryException {
        return this.clazz.isInstance(value) ? value : value.toJava();
    }

    private String name() {
        return String.valueOf(Util.className(this.clazz)) + '.' + this.method;
    }

    @Override
    public void plan(FElem plan) {
        JavaFunc.addPlan(plan, this.planElem("name", String.valueOf(this.clazz.getName()) + '.' + this.method), this.exprs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaFunc)) {
            return false;
        }
        JavaFunc j = (JavaFunc)obj;
        return this.clazz.equals(j.clazz) && this.method.equals(j.method) && Array.equals(this.types, j.types) && super.equals(obj);
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        if (this.method.equals("new")) {
            sb.append("new").append(' ').append(Util.className(this.clazz));
        } else {
            sb.append(this.name());
        }
        return sb.append("(...)").toString();
    }

    @Override
    public String toString() {
        return this.clazz + "." + this.method + "(" + this.toString(", ") + ")";
    }
}

