/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.TypedFunc;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.iter.BasicIter;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Closure
extends Single
implements Scope,
XQFunctionExpr {
    private final QNm name;
    private final Var[] params;
    private SeqType declType;
    private AnnList anns;
    private boolean updating;
    private final EnumMap<Flag, Boolean> map = new EnumMap(Flag.class);
    private boolean compiled;
    private final VarScope vs;
    private final Map<Var, Expr> global;

    public Closure(InputInfo info, SeqType declType, Var[] params, Expr expr, AnnList anns, Map<Var, Expr> global, VarScope vs) {
        this(info, null, declType, params, expr, anns, global, vs);
    }

    Closure(InputInfo info, QNm name, SeqType declType, Var[] params, Expr expr, AnnList anns, Map<Var, Expr> global, VarScope vs) {
        super(info, expr, SeqType.FUNC_O);
        this.name = name;
        this.params = params;
        this.declType = declType == null || declType.eq(SeqType.ITEM_ZM) ? null : declType;
        this.anns = anns;
        this.global = global == null ? Collections.emptyMap() : global;
        this.vs = vs;
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int pos) {
        return this.params[pos].name;
    }

    @Override
    public FuncType funcType() {
        return FuncType.get(this.anns, this.declType, this.params);
    }

    @Override
    public AnnList annotations() {
        return this.anns;
    }

    @Override
    public void comp(CompileContext cc) throws QueryException {
        this.compile(cc);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        block7: {
            if (this.compiled) {
                return this;
            }
            this.compiled = true;
            this.checkUpdating();
            for (Map.Entry<Var, Expr> e : this.global.entrySet()) {
                Expr bound = e.getValue().compile(cc);
                e.setValue(bound);
                e.getKey().refineType(bound.seqType(), cc);
            }
            cc.pushScope(this.vs);
            try {
                try {
                    this.expr = this.expr.compile(cc);
                }
                catch (QueryException qe) {
                    this.expr = cc.error(qe, this.expr);
                    cc.removeScope(this);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                cc.removeScope(this);
                throw throwable;
            }
            cc.removeScope(this);
        }
        this.expr.markTailCalls(cc);
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        block12: {
            SeqType st = this.expr.seqType();
            SeqType dt = this.declType == null || st.instanceOf(this.declType) ? st : this.declType;
            this.exprType.assign(FuncType.get(this.anns, dt, this.params));
            cc.pushScope(this.vs);
            try {
                try {
                    Iterator<Map.Entry<Var, Expr>> iter = this.global.entrySet().iterator();
                    HashMap<Var, Expr> add = null;
                    int limit = cc.qc.context.options.get(MainOptions.INLINELIMIT);
                    while (iter.hasNext()) {
                        Closure cl;
                        Map.Entry<Var, Expr> entry = iter.next();
                        Var var = entry.getKey();
                        Expr ex = entry.getValue();
                        if (ex instanceof Value) {
                            Expr inlined = this.expr.inline(var, var.checkType((Value)ex, cc.qc, true), cc);
                            if (inlined != null) {
                                this.expr = inlined;
                            }
                            iter.remove();
                            continue;
                        }
                        if (!(ex instanceof Closure) || (cl = (Closure)ex).has(Flag.NDT) || cl.global.size() >= 5 || this.expr.count(var) == VarUsage.MORE_THAN_ONCE || cl.exprSize() >= limit) continue;
                        cc.info("inline %", entry);
                        for (Map.Entry<Var, Expr> expr2 : cl.global.entrySet()) {
                            Var var2 = cc.copy(expr2.getKey(), null);
                            if (add == null) {
                                add = new HashMap<Var, Expr>();
                            }
                            add.put(var2, expr2.getValue());
                            expr2.setValue(new VarRef(cl.info, var2));
                        }
                        Expr inlined = this.expr.inline(var, cl, cc);
                        if (inlined != null) {
                            this.expr = inlined;
                        }
                        iter.remove();
                    }
                    if (add != null) {
                        this.global.putAll(add);
                    }
                }
                catch (QueryException qe) {
                    this.expr = cc.error(qe, this.expr);
                    cc.removeScope(this);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                cc.removeScope(this);
                throw throwable;
            }
            cc.removeScope(this);
        }
        return this.global.isEmpty() ? cc.preEval(this) : this;
    }

    @Override
    public VarUsage count(Var var) {
        VarUsage all = VarUsage.NEVER;
        for (Map.Entry<Var, Expr> e : this.global.entrySet()) {
            if ((all = all.plus(e.getValue().count(var))) == VarUsage.MORE_THAN_ONCE) break;
        }
        return all;
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = false;
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            Expr exp = entry.getValue().inline(var, ex, cc);
            if (exp == null) continue;
            changed = true;
            entry.setValue(exp);
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        VarScope innerScope = new VarScope(this.vs.sc);
        HashMap<Var, Expr> outer = new HashMap<Var, Expr>();
        this.global.forEach((key, value) -> {
            Expr expr = outer.put((Var)key, value.copy(cc, vm));
        });
        cc.pushScope(innerScope);
        try {
            IntObjMap<Var> innerVars = new IntObjMap<Var>();
            this.vs.copy(cc, innerVars);
            HashMap<Var, Expr> nl = new HashMap<Var, Expr>();
            outer.forEach((key, value) -> {
                Expr expr = nl.put((Var)innerVars.get(key.id), (Expr)value);
            });
            Var[] prms = (Var[])this.params.clone();
            int pl = prms.length;
            int p = 0;
            while (p < pl) {
                prms[p] = innerVars.get(prms[p].id);
                ++p;
            }
            Expr ex = this.expr.copy(cc, innerVars);
            ex.markTailCalls(null);
            Closure closure = this.copyType(new Closure(this.info, this.name, this.declType, prms, ex, this.anns, nl, cc.vs()));
            return closure;
        }
        finally {
            cc.removeScope();
        }
    }

    @Override
    public Expr inlineExpr(Expr[] exprs, CompileContext cc, InputInfo ii) throws QueryException {
        if (this.expr.has(Flag.CTX)) {
            return null;
        }
        cc.info("inline %", this);
        LinkedList<Clause> clauses = exprs.length == 0 && this.global.isEmpty() ? null : new LinkedList<Clause>();
        IntObjMap<Var> vm = new IntObjMap<Var>();
        int pl = this.params.length;
        int p = 0;
        while (p < pl) {
            clauses.add(new Let(cc.copy(this.params[p], vm), exprs[p], false).optimize(cc));
            ++p;
        }
        for (Map.Entry<Var, Expr> e : this.global.entrySet()) {
            clauses.add(new Let(cc.copy(e.getKey(), vm), e.getValue(), false).optimize(cc));
        }
        Expr cpy = this.expr.copy(cc, vm);
        Expr dt = this.declType == null ? cpy : new TypeCheck(this.vs.sc, ii, cpy, this.declType, true).optimize(cc);
        return clauses == null ? dt : new GFLWOR(ii, clauses, dt).optimize(cc);
    }

    @Override
    public FuncItem item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr checked;
        Expr body;
        if (this.global.isEmpty()) {
            body = this.expr;
        } else {
            LinkedList<Clause> clauses = new LinkedList<Clause>();
            for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
                clauses.add(new Let(entry.getKey(), entry.getValue().value(qc), false));
            }
            body = new GFLWOR(this.info, clauses, this.expr);
        }
        SeqType argType = body.seqType();
        if (this.declType == null || argType.instanceOf(this.declType)) {
            checked = body;
        } else if (body instanceof FuncItem && this.declType.type instanceof FuncType) {
            if (!this.declType.occ.check(1L)) {
                throw QueryError.typeError(body, this.declType, null, this.info);
            }
            FuncItem fi = (FuncItem)body;
            checked = fi.coerceTo((FuncType)this.declType.type, qc, this.info, true);
        } else if (body instanceof Value) {
            Value value = (Value)body;
            checked = this.declType.instance(value) ? value : this.declType.promote(value, null, qc, this.vs.sc, this.info, false);
        } else {
            Occ occ;
            if (argType.type.instanceOf(this.declType.type) && !body.has(Flag.NDT) && (occ = argType.occ.intersect(this.declType.occ)) == null) {
                throw QueryError.typeError(body, this.declType, null, this.info);
            }
            checked = new TypeCheck(this.vs.sc, this.info, body, this.declType, true);
        }
        FuncType type = (FuncType)this.seqType().type;
        return new FuncItem(this.vs.sc, this.anns, this.name, this.params, type, checked, this.vs.stackSize());
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.item(qc, this.info);
    }

    @Override
    public BasicIter<?> iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public boolean has(Flag ... flags) {
        Flag flag2;
        ArrayList<Flag> flgs = new ArrayList<Flag>();
        Flag[] flagArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            flag2 = flagArray[n2];
            if (!this.map.containsKey((Object)flag2)) {
                this.map.put(flag2, false);
                if (flag2 != Flag.UPD) {
                    flgs.add(flag2);
                }
            }
            ++n2;
        }
        for (Flag flag2 : flgs) {
            this.map.put(flag2, this.expr.has(flag2));
        }
        flagArray = flags;
        n = flags.length;
        int n3 = 0;
        while (n3 < n) {
            flag2 = flagArray[n3];
            if (this.map.get((Object)flag2).booleanValue()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean removable(Var var) {
        for (Map.Entry<Var, Expr> e : this.global.entrySet()) {
            if (e.getValue().removable(var)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Map.Entry<Var, Expr> v : this.global.entrySet()) {
            if (v.getValue().accept(visitor) && visitor.declared(v.getKey())) continue;
            return false;
        }
        Var[] varArray = this.params;
        int n = this.params.length;
        int n2 = 0;
        while (n2 < n) {
            Var var = varArray[n2];
            if (!visitor.declared(var)) {
                return false;
            }
            ++n2;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkUpdating();
        if (this.updating) {
            this.expr.checkUp();
            if (this.declType != null && !this.declType.zero()) {
                throw QueryError.UUPFUNCTYPE.get(this.info, new Object[0]);
            }
        }
    }

    @Override
    public boolean isVacuous() {
        return this.declType != null && this.declType.zero() && !this.has(Flag.UPD);
    }

    @Override
    public boolean isVacuousBody() {
        return this.isVacuous();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Expr ex : this.global.values()) {
            if (ex.accept(visitor)) continue;
            return false;
        }
        return visitor.inlineFunc(this);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Expr ex : this.global.values()) {
            size += ex.exprSize();
        }
        return size + this.expr.exprSize();
    }

    @Override
    public boolean compiled() {
        return this.compiled;
    }

    public Iterator<Map.Entry<Var, Expr>> globalBindings() {
        return this.global.entrySet().iterator();
    }

    void adoptSignature(FuncType ft) {
        this.anns = ft.anns;
        int pl = this.params.length;
        int p = 0;
        while (p < pl) {
            this.params[p].declType = ft.argTypes[p];
            ++p;
        }
        SeqType dt = ft.declType;
        if (!dt.eq(SeqType.ITEM_ZM)) {
            this.declType = dt;
        }
    }

    private void checkUpdating() throws QueryException {
        this.updating = this.expr.has(Flag.UPD);
        boolean updAnn = this.anns.contains(Annotation.UPDATING);
        if (this.updating != updAnn) {
            if (!updAnn) {
                this.anns.add(new Ann(this.info, Annotation.UPDATING, new Item[0]));
            } else if (!this.expr.isVacuous()) {
                throw QueryError.UPEXPECTF.get(this.info, new Object[0]);
            }
        }
    }

    public static Closure undeclaredLiteral(QNm name, int arity, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        VarScope vs = new VarScope(sc);
        Var[] params = new Var[arity];
        Expr[] args = new Expr[arity];
        int a = 0;
        while (a < arity) {
            params[a] = vs.addNew(new QNm("arg" + (a + 1), ""), null, true, qc, info);
            args[a] = new VarRef(info, params[a]);
            ++a;
        }
        TypedFunc call = qc.funcs.undeclaredFuncCall(name, args, sc, info);
        return new Closure(info, name, null, params, call.func, new AnnList(), null, vs);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        this.global.forEach((key, value) -> {
            key.plan(elem);
            value.plan(elem);
        });
        Closure.addPlan(plan, elem, this.expr);
        int pl = this.params.length;
        int p = 0;
        while (p < pl) {
            elem.add(Closure.planAttr("arg" + p, this.params[p].name.string()));
            ++p;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.global.isEmpty()) {
            sb.append("((: inline-closure :) ");
            this.global.forEach((k, v) -> {
                StringBuilder stringBuilder2 = sb.append("let ").append(k).append(" := ").append(v).append(' ');
            });
            sb.append("return").append(' ');
        }
        sb.append("function").append("(");
        int pl = this.params.length;
        int p = 0;
        while (p < pl) {
            if (p > 0) {
                sb.append(", ");
            }
            sb.append(this.params[p]);
            ++p;
        }
        sb.append(")").append(' ');
        sb.append("as ").append(this.declType != null ? this.declType : SeqType.ITEM_ZM).append(' ');
        sb.append("{ ").append(this.expr).append(" }");
        if (!this.global.isEmpty()) {
            sb.append(')');
        }
        return sb.toString();
    }
}

