/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.StringRange;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.func.Function;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.DBNodeIter;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class StringRangeAccess
extends IndexAccess {
    private final StringRange index;

    public StringRangeAccess(InputInfo info, StringRange index, IndexDb db) {
        super(db, info, index.type());
        this.index = index;
    }

    @Override
    public BasicNodeIter iter(QueryContext qc) throws QueryException {
        IndexType type = this.index.type();
        Data data = this.db.data(qc, type);
        return new DBNodeIter(data, type){
            final byte kind;
            final IndexIterator ii;
            {
                this.kind = (byte)(indexType == IndexType.TEXT ? 2 : 3);
                this.ii = ((StringRangeAccess)StringRangeAccess.this).index.min.length <= this.data.meta.maxlen && ((StringRangeAccess)StringRangeAccess.this).index.max.length <= this.data.meta.maxlen ? this.data.iter(StringRangeAccess.this.index) : StringRangeAccess.this.scan(this.data);
            }

            @Override
            public DBNode next() {
                return this.ii.more() ? new DBNode(this.data, this.ii.pre(), this.kind) : null;
            }
        };
    }

    private IndexIterator scan(final Data data) {
        return new IndexIterator(){
            final boolean text;
            final byte kind;
            final int sz;
            int pre;
            {
                this.text = StringRangeAccess.this.index.type() == IndexType.TEXT;
                this.kind = (byte)(this.text ? 2 : 3);
                this.sz = data2.meta.size;
                this.pre = -1;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.sz) {
                    if (data.kind(this.pre) != this.kind) continue;
                    byte[] txt = data.text(this.pre, this.text);
                    int min = Token.diff(txt, ((StringRangeAccess)StringRangeAccess.this).index.min);
                    int max = Token.diff(txt, ((StringRangeAccess)StringRangeAccess.this).index.max);
                    if (min < (((StringRangeAccess)StringRangeAccess.this).index.mni ? 0 : 1) || max > (((StringRangeAccess)StringRangeAccess.this).index.mxi ? 0 : 1)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return Math.max(1, this.sz >>> 2);
            }
        };
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new StringRangeAccess(this.info, this.index, (IndexDb)this.db.copy(cc, (IntObjMap)vm));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StringRangeAccess && this.index.equals(((StringRangeAccess)obj).index) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        StringRangeAccess.addPlan(plan, this.planElem(new Object[]{"index", this.index.type(), "min", this.index.min, "max", this.index.max}), this.db);
    }

    @Override
    public String toString() {
        Function func = this.index.type() == IndexType.TEXT ? Function._DB_TEXT_RANGE : Function._DB_ATTRIBUTE_RANGE;
        return func.args(this.db.source(), Str.get(this.index.min), Str.get(this.index.max)).substring(1);
    }
}

