/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.NumericRange;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.func.Function;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.DBNodeIter;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class RangeAccess
extends IndexAccess {
    private final NumericRange index;

    public RangeAccess(InputInfo info, NumericRange index, IndexDb db) {
        super(db, info, index.type());
        this.index = index;
    }

    @Override
    public BasicNodeIter iter(QueryContext qc) throws QueryException {
        IndexType type = this.index.type();
        Data data = this.db.data(qc, type);
        return new DBNodeIter(data, type){
            final byte kind;
            final IndexIterator ii;
            {
                this.kind = (byte)(indexType == IndexType.TEXT ? 2 : 3);
                this.ii = this.data.iter(RangeAccess.this.index);
            }

            @Override
            public DBNode next() {
                return this.ii.more() ? new DBNode(this.data, this.ii.pre(), this.kind) : null;
            }
        };
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new RangeAccess(this.info, this.index, (IndexDb)this.db.copy(cc, (IntObjMap)vm));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RangeAccess && this.index.equals(((RangeAccess)obj).index) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        RangeAccess.addPlan(plan, this.planElem(new Object[]{"index", this.index.type(), "min", this.index.min, "max", this.index.max}), this.db);
    }

    @Override
    public String toString() {
        Function func = this.index.type() == IndexType.TEXT ? Function._DB_TEXT_RANGE : Function._DB_ATTRIBUTE_RANGE;
        return func.args(this.db.source(), Dbl.get(this.index.min), Dbl.get(this.index.max)).substring(1);
    }
}

