/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class FTExpr
extends ParseExpr {
    public final FTExpr[] exprs;

    FTExpr(InputInfo info, FTExpr ... exprs) {
        super(info, SeqType.BLN_O);
        this.exprs = exprs;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.exprs);
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        int es = this.exprs.length;
        int e = 0;
        while (e < es) {
            this.exprs[e] = this.exprs[e].compile(cc);
            ++e;
        }
        return this;
    }

    @Override
    public FTExpr optimize(CompileContext cc) {
        return this;
    }

    @Override
    public abstract FTNode item(QueryContext var1, InputInfo var2) throws QueryException;

    @Override
    public abstract FTIter iter(QueryContext var1) throws QueryException;

    @Override
    public boolean has(Flag ... flags) {
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            if (expr.has(flags)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean removable(Var var) {
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            if (!((Expr)expr).removable(var)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.exprs);
    }

    @Override
    public FTExpr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        return FTExpr.inlineAll(this.exprs, var, ex, cc) ? this.optimize(cc) : null;
    }

    @Override
    public abstract FTExpr copy(CompileContext var1, IntObjMap<Var> var2);

    public boolean usesExclude() {
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            if (expr.usesExclude()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return FTExpr.visitAll(visitor, this.exprs);
    }

    @Override
    public int exprSize() {
        int size = 1;
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            size += ((Expr)expr).exprSize();
            ++n2;
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FTExpr && Array.equals(this.exprs, ((FTExpr)obj).exprs);
    }

    @Override
    public void plan(FElem plan) {
        FTExpr.addPlan(plan, this.planElem(new Object[0]), this.exprs);
    }

    final String toString(Object sep) {
        StringBuilder sb = new StringBuilder();
        int es = this.exprs.length;
        int e = 0;
        while (e < es) {
            sb.append(e == 0 ? "" : sep.toString()).append(this.exprs[e]);
            ++e;
        }
        return sb.toString();
    }
}

