/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CNode;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class CTxt
extends CNode {
    private boolean simple;

    public CTxt(StaticContext sc, InputInfo info, Expr text) {
        super(sc, info, SeqType.TXT_ZO, text);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        boolean atom;
        Expr expr = this.exprs[0];
        SeqType st = expr.seqType();
        if (st.zero()) {
            return cc.replaceWith(this, expr);
        }
        boolean bl = atom = !st.mayBeArray();
        if (st.oneOrMore() && atom) {
            this.exprType.assign(Occ.ONE);
        }
        this.simple = st.zeroOrOne() && atom;
        return this;
    }

    @Override
    public FTxt item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Expr expr = this.exprs[0];
        if (this.simple) {
            Item item2 = expr.item(qc, ii);
            return new FTxt(item2 == null ? Token.EMPTY : item2.string(this.info));
        }
        TokenBuilder tb = new TokenBuilder();
        boolean more = false;
        Iter iter = expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (more) {
                tb.add(32);
            }
            tb.add(item.string(this.info));
            more = true;
        }
        return more ? new FTxt(tb.finish()) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        CTxt ctxt = this.copyType(new CTxt(this.sc, this.info, this.exprs[0].copy(cc, vm)));
        ctxt.simple = this.simple;
        return ctxt;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CTxt && super.equals(obj);
    }

    @Override
    public String description() {
        return CTxt.info("text");
    }

    @Override
    public String toString() {
        return this.toString("text");
    }
}

