/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import java.util.LinkedList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.func.fn.FnBoolean;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Quantifier
extends Single {
    private final boolean every;

    public Quantifier(InputInfo info, For[] inputs, Expr expr, boolean every, StaticContext sc) {
        this(info, (Expr)new GFLWOR(info, new LinkedList<Clause>(Arrays.asList(inputs)), FnBoolean.get(expr, info, sc)), every);
    }

    private Quantifier(InputInfo info, Expr tests, boolean every) {
        super(info, tests, SeqType.BLN_O);
        this.every = every;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        GFLWOR gflwor;
        if (this.expr instanceof Value) {
            return cc.preEval(this);
        }
        if (this.expr instanceof GFLWOR && !this.expr.has(Flag.NDT) && (gflwor = (GFLWOR)this.expr).size() > 0L && gflwor.ret instanceof Value) {
            Value value = (Value)gflwor.ret;
            return cc.replaceWith(this, Bln.get(value.ebv(cc.qc, this.info).bool(this.info)));
        }
        return this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter iter = this.expr.iter(qc);
        while ((item = qc.next(iter)) != null) {
            if (!(this.every ^ item.bool(this.info))) continue;
            return Bln.get(!this.every);
        }
        return Bln.get(this.every);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new Quantifier(this.info, this.expr.copy(cc, vm), this.every);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Quantifier && this.every == ((Quantifier)obj).every && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Quantifier.addPlan(plan, this.planElem("option", this.every ? "every" : "some"), this.expr);
    }

    @Override
    public String toString() {
        if (this.expr instanceof GFLWOR) {
            StringBuilder sb = new StringBuilder(this.every ? "every" : "some").append(' ');
            GFLWOR gflwor = (GFLWOR)this.expr;
            int c = 0;
            for (Clause clause : gflwor.clauses) {
                if (c++ != 0) {
                    sb.append(", ");
                }
                sb.append(clause.toString().replaceAll("^for ", ""));
            }
            return sb.append(' ').append("satisfies").append(' ').append(gflwor.ret).toString();
        }
        return this.expr.toString();
    }
}

