/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Union;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class Or
extends Logical {
    public Or(InputInfo info, Expr ... exprs) {
        super(info, exprs);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        return this.optimize(cc, false, ex -> new And(this.info, (Expr)ex));
    }

    @Override
    void simplify(CompileContext cc, ExprList list) throws QueryException {
        int es = this.exprs.length;
        int e = 0;
        while (e < es) {
            Expr expr = this.exprs[e];
            if (expr instanceof CmpG) {
                while (e + 1 < es && this.exprs[e + 1] instanceof CmpG) {
                    Expr tmp = ((CmpG)expr).union((CmpG)this.exprs[e + 1], cc);
                    if (tmp == null) break;
                    expr = tmp;
                    ++e;
                }
            }
            if (!list.contains(expr) || expr.has(Flag.NDT)) {
                list.add(cc.replaceWith(this.exprs[e], expr));
            } else {
                cc.info("remove % from %", this.exprs[e], this.description());
            }
            ++e;
        }
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        if (qc.scoring) {
            double score = 0.0;
            boolean found = false;
            Expr[] exprArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                Expr expr = exprArray[n2];
                Item item = expr.ebv(qc, this.info);
                found |= item.bool(this.info);
                score += item.score();
                ++n2;
            }
            return Bln.get(found, Scoring.avg(score, this.exprs.length));
        }
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n3 = 0;
        while (n3 < n) {
            Expr expr = exprArray[n3];
            if (expr.ebv(qc, this.info).bool(this.info)) {
                return Bln.TRUE;
            }
            ++n3;
        }
        return Bln.FALSE;
    }

    @Override
    public Or copy(CompileContext cc, IntObjMap<Var> vm) {
        return new Or(this.info, Or.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        ExprList list = new ExprList(this.exprs.length);
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            if (ii.costs.results() != 0) {
                costs = IndexCosts.add(costs, ii.costs);
                list.add(ii.expr);
            }
            ++n2;
        }
        ii.costs = costs;
        ii.expr = list.size() == 1 ? (Expr)list.get(0) : new Union(this.info, (Expr[])list.finish());
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Or && super.equals(obj);
    }

    @Override
    public String toString() {
        return this.toString(" or ");
    }
}

