/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.NSContext;
import org.basex.query.util.UriResolver;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.SeqType;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

public final class StaticContext {
    public final TokenObjMap<DecFormatter> decFormats = new TokenObjMap();
    public final NSContext ns = new NSContext();
    public final boolean mixUpdates;
    public Collation collation;
    public byte[] elemNS;
    public byte[] funcNS = QueryText.FN_URI;
    public boolean dynFuncCall;
    SeqType contextType;
    public boolean strip;
    public boolean ordered = true;
    public boolean orderGreatest;
    public boolean spaces;
    public boolean preserveNS = true;
    public boolean inheritNS = true;
    private Uri baseURI = Uri.EMPTY;
    UriResolver resolver;

    public StaticContext(QueryContext qc) {
        this.mixUpdates = qc.context.options.get(MainOptions.MIXUPDATES);
    }

    void namespace(String prefix, String uri) throws QueryException {
        if (prefix.isEmpty()) {
            this.elemNS = uri.isEmpty() ? null : Token.token(uri);
        } else if (uri.isEmpty()) {
            this.ns.delete(Token.token(prefix));
        } else {
            this.ns.add(Token.token(prefix), Token.token(uri), null);
        }
    }

    public Uri baseURI() {
        return this.baseURI;
    }

    public void baseURI(String uri) {
        String string = "";
        if (uri != null) {
            if (uri.isEmpty()) {
                return;
            }
            String string2 = string = IO.get(uri) instanceof IOContent ? uri : this.resolve(uri).url();
            if (!string.endsWith("/") && (uri.endsWith(".") || uri.endsWith("/"))) {
                string = String.valueOf(string) + '/';
            }
        }
        this.baseURI = Uri.uri(string);
    }

    public IO baseIO() {
        return this.baseURI == Uri.EMPTY ? null : IO.get(Token.string(this.baseURI.string()));
    }

    public IO resolve(String path) {
        IO baseIO = this.baseIO();
        return baseIO == null ? IO.get(path) : baseIO.merge(path);
    }

    public IO resolve(String path, String uri) {
        return this.resolver == null ? this.resolve(path) : this.resolver.resolve(path, uri, this.baseURI);
    }

    public DecFormatter decFormat(byte[] id) throws QueryException {
        DecFormatter df = this.decFormats.get(id);
        if (df == null && Token.eq(id, Token.EMPTY)) {
            df = new DecFormatter(null, null);
            this.decFormats.put(id, df);
        }
        return df;
    }

    public String toString() {
        return String.valueOf(Util.className(this)) + '[' + this.baseIO() + ']';
    }
}

