/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.csv.CsvOptions;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.StandardSerializer;
import org.basex.query.QueryError;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

abstract class CsvSerializer
extends StandardSerializer {
    final CsvOptions copts;
    final int separator;
    final boolean quotes;
    final boolean backslashes;
    boolean header;

    CsvSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
        this.copts = opts.get(SerializerOptions.CSV);
        this.quotes = this.copts.get(CsvOptions.QUOTES);
        this.backslashes = this.copts.get(CsvOptions.BACKSLASHES);
        this.header = this.copts.get(CsvOptions.HEADER);
        this.separator = this.copts.separator();
    }

    final void record(TokenList entries) throws IOException {
        int fs = entries.size();
        int i = 0;
        while (i < fs) {
            boolean special;
            byte[] v = (byte[])entries.get(i);
            if (i != 0) {
                this.out.print(this.separator);
            }
            byte[] txt = v == null ? Token.EMPTY : v;
            boolean delim = Token.contains(txt, this.separator) || Token.contains(txt, 10);
            boolean bl = special = Token.contains(txt, 13) || Token.contains(txt, 9) || Token.contains(txt, 34);
            if (delim || special || this.backslashes && Token.contains(txt, 92)) {
                TokenBuilder tb = new TokenBuilder();
                if (delim && !this.backslashes && !this.quotes) {
                    throw QueryError.CSV_SERIALIZE_X.getIO(Util.info("Output must be put into quotes: %", new Object[]{QueryError.chop(txt, null)}));
                }
                if (this.quotes && (delim || special)) {
                    tb.add(34);
                }
                int len = txt.length;
                int c = 0;
                while (c < len) {
                    int cp = Token.cp(txt, c);
                    if (this.backslashes) {
                        if (cp == 10) {
                            tb.add("\\n");
                        } else if (cp == 13) {
                            tb.add("\\r");
                        } else if (cp == 9) {
                            tb.add("\\t");
                        } else if (cp == 34) {
                            tb.add("\\\"");
                        } else if (cp == 92) {
                            tb.add("\\\\");
                        } else if (cp == this.separator && !this.quotes) {
                            tb.add(92).add(cp);
                        } else {
                            tb.add(cp);
                        }
                    } else {
                        if (cp == 34) {
                            tb.add(34);
                        }
                        tb.add(cp);
                    }
                    c += Token.cl(txt, c);
                }
                if (this.quotes && (delim || special)) {
                    tb.add(34);
                }
                txt = tb.finish();
            }
            this.out.print(txt);
            ++i;
        }
        this.out.print(10);
        entries.reset();
    }

    @Override
    protected void atomic(Item value) throws IOException {
        throw QueryError.CSV_SERIALIZE_X.getIO("Atomic values cannot be serialized");
    }
}

