/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.basex.io.in.BufferInput;
import org.basex.io.serial.AdaptiveSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;

public final class BaseXSerializer
extends AdaptiveSerializer {
    private final boolean binary;
    private int nested;

    BaseXSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts, false);
        this.binary = sopts.yes(SerializerOptions.BINARY);
    }

    @Override
    protected void atomic(Item item) throws IOException {
        if (this.nested == 0) {
            try {
                if (this.binary && item instanceof Bin) {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferInput is = item.input(null);){
                        int b;
                        while ((b = ((InputStream)is).read()) != -1) {
                            this.out.write(b);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.printChars(item.string(null));
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        } else {
            super.atomic(item);
        }
    }

    @Override
    protected void array(Array item) throws IOException {
        ++this.nested;
        super.array(item);
        --this.nested;
    }

    @Override
    protected void map(Map item) throws IOException {
        ++this.nested;
        super.map(item);
        --this.nested;
    }
}

