/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.MetaData;
import org.basex.io.out.DataOutput;

public final class TableOutput
extends OutputStream {
    private final byte[] buffer = new byte[4096];
    private final OutputStream os;
    private final MetaData meta;
    private final String file;
    private int pos;
    private int pages;

    public TableOutput(MetaData md, String fn) throws IOException {
        this.os = new FileOutputStream(md.dbfile(fn).file());
        this.meta = md;
        this.file = fn;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos == 4096) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        if (this.pos == 0) {
            return;
        }
        this.os.write(this.buffer);
        ++this.pages;
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
        boolean empty;
        boolean bl = empty = this.pages == 0 && this.pos == 0;
        if (empty) {
            ++this.pos;
        }
        this.flush();
        this.os.close();
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataOutput out = new DataOutput(this.meta.dbfile(String.valueOf(this.file) + 'i'));){
            out.writeNum(this.pages);
            out.writeNum(empty ? 0 : Integer.MAX_VALUE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

