/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.out.BufferOutput;
import org.basex.util.Token;

public class PrintOutput
extends OutputStream {
    protected final OutputStream os;
    protected long max = Long.MAX_VALUE;
    protected long size;

    PrintOutput() {
        this((OutputStream)null);
    }

    public PrintOutput(String fn) throws IOException {
        this(new BufferOutput(fn));
    }

    protected PrintOutput(OutputStream os) {
        this.os = os;
    }

    public static PrintOutput get(OutputStream out) {
        return out instanceof PrintOutput ? (PrintOutput)out : new PrintOutput(out instanceof ByteArrayOutputStream || out instanceof BufferedOutputStream || out instanceof BufferOutput ? out : new BufferOutput(out));
    }

    public final void setLimit(int limit) {
        this.max = limit;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.size++ < this.max) {
            this.os.write(b);
        }
    }

    public void print(int cp) throws IOException {
        if (cp <= 127) {
            this.write(cp);
        } else if (cp <= 2047) {
            this.write(cp >> 6 & 0x1F | 0xC0);
            this.write(cp & 0x3F | 0x80);
        } else if (cp <= 65535) {
            this.write(cp >> 12 & 0xF | 0xE0);
            this.write(cp >> 6 & 0x3F | 0x80);
            this.write(cp & 0x3F | 0x80);
        } else {
            this.write(cp >> 18 & 7 | 0xF0);
            this.write(cp >> 12 & 0x3F | 0x80);
            this.write(cp >> 6 & 0x3F | 0x80);
            this.write(cp & 0x3F | 0x80);
        }
    }

    public void print(byte[] token) throws IOException {
        int tl = token.length;
        int t = 0;
        while (t < tl) {
            this.print(Token.cp(token, t));
            t += Token.cl(token, t);
        }
    }

    public void print(String string) throws IOException {
        this.print(Token.token(string));
    }

    public final void println(String string) throws IOException {
        this.print(string);
        this.print(10);
    }

    public final void println(byte[] token) throws IOException {
        this.print(token);
        this.print(10);
    }

    public final long size() {
        return this.size;
    }

    @Override
    public final void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.os != null) {
            if (this.os == System.out || this.os == System.err) {
                this.os.flush();
            } else {
                this.os.close();
            }
        }
    }

    public boolean finished() {
        return this.size == this.max;
    }
}

