/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import org.basex.io.IO;
import org.basex.io.out.BufferOutput;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public final class IOFile
extends IO {
    public static final FileFilter NO_HIDDEN = file -> !file.getName().startsWith(".");
    private static final Pattern VALIDNAME = Pattern.compile("^[^\\\\/" + (Prop.WIN ? ":*?\"<>|" : "") + "]+$");
    private final boolean absolute;
    private final File file;

    public IOFile(File file, String last) {
        super(IOFile.create(file.getAbsolutePath(), last));
        boolean abs = file.isAbsolute();
        File file2 = this.file = abs ? file : new File(this.pth);
        if (!abs && Prop.WIN) {
            String p = file.getPath();
            abs = p.startsWith("/") || p.startsWith("\\");
        }
        this.absolute = abs;
    }

    public IOFile(File file) {
        this(file, "");
    }

    public IOFile(String path) {
        this(new File(path), path);
    }

    public IOFile(String dir, String child) {
        this(new File(dir, child), child);
    }

    public IOFile(IOFile dir, String child) {
        this(new File(dir.file, child), child);
    }

    public File file() {
        return this.file;
    }

    public boolean touch() {
        try {
            Files.createFile(this.toPath(), new FileAttribute[0]);
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    @Override
    public byte[] read() throws IOException {
        return Files.readAllBytes(this.toPath());
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDir() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public long timeStamp() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.url());
    }

    @Override
    public StreamSource streamSource() {
        return new StreamSource(this.pth);
    }

    @Override
    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public IOFile resolve(String path) {
        IOFile f = new IOFile(path);
        return f.absolute ? f : new IOFile(this.isDir() ? this.pth : this.dir(), path);
    }

    public boolean md() {
        return this.file.exists() || this.file.mkdirs();
    }

    public IOFile parent() {
        String parent = this.file.getParent();
        return parent == null ? null : new IOFile(String.valueOf(parent) + '/');
    }

    public IOFile[] children() {
        return this.children(".*");
    }

    public IOFile[] children(String regex) {
        File[] children = this.file.listFiles();
        if (children == null) {
            return new IOFile[0];
        }
        ArrayList<IOFile> io = new ArrayList<IOFile>(children.length);
        Pattern pattern = Pattern.compile(regex, Prop.CASE ? 0 : 2);
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (pattern.matcher(child.getName()).matches()) {
                io.add(new IOFile(child));
            }
            ++n2;
        }
        return io.toArray(new IOFile[io.size()]);
    }

    public IOFile[] children(FileFilter filter) {
        File[] children;
        File[] fileArray = children = filter == null ? this.file.listFiles() : this.file.listFiles(filter);
        if (children == null) {
            return new IOFile[0];
        }
        ArrayList<IOFile> io = new ArrayList<IOFile>(children.length);
        File[] fileArray2 = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray2[n2];
            io.add(new IOFile(child));
            ++n2;
        }
        return io.toArray(new IOFile[io.size()]);
    }

    public StringList descendants() {
        return this.descendants(null);
    }

    public StringList descendants(FileFilter filter) {
        File[] children;
        StringList files = new StringList();
        File[] fileArray = children = filter == null ? this.file.listFiles() : this.file.listFiles(filter);
        if (children == null) {
            return files;
        }
        if (this.exists()) {
            IOFile.addDescendants(this, files, filter, this.path().length() + 1);
        }
        return files;
    }

    public void write(byte[] bytes) throws IOException {
        Files.write(this.toPath(), bytes, new OpenOption[0]);
    }

    public void write(InputStream in) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferOutput out = new BufferOutput(this.pth);){
            int i;
            while ((i = in.read()) != -1) {
                out.write(i);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean delete() {
        boolean ok = true;
        if (this.file.exists()) {
            if (this.isDir()) {
                IOFile[] iOFileArray = this.children();
                int n = iOFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IOFile ch = iOFileArray[n2];
                    ok &= ch.delete();
                    ++n2;
                }
            }
            try {
                Files.delete(this.toPath());
            }
            catch (IOException ex) {
                Util.debug(ex);
                return false;
            }
        }
        return ok;
    }

    public boolean rename(IOFile target) {
        return this.file.renameTo(target.file);
    }

    public void copyTo(IOFile target) throws IOException {
        target.parent().md();
        Files.copy(this.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public boolean eq(IO io) {
        return io instanceof IOFile && (Prop.CASE ? this.pth.equals(io.pth) : this.pth.equalsIgnoreCase(io.pth));
    }

    public boolean equals(Object obj) {
        return obj instanceof IOFile && ((IOFile)obj).pth.equals(this.pth);
    }

    @Override
    public String url() {
        String path = this.pth.startsWith("/") ? this.pth.substring(1) : this.pth;
        TokenBuilder tb = new TokenBuilder("file:/").add("//");
        int pl = path.length();
        int p = 0;
        while (p < pl) {
            char ch = path.charAt(p);
            if (ch == ' ') {
                tb.add("%20");
            } else {
                tb.add(ch);
            }
            ++p;
        }
        return tb.toString();
    }

    public void open() throws IOException {
        String[] args = Prop.WIN ? new String[]{"rundll32", "url.dll,FileProtocolHandler", this.pth} : (Prop.MAC ? new String[]{"/usr/bin/open", this.pth} : new String[]{"xdg-open", this.pth});
        new ProcessBuilder(args).directory(this.parent().file).start();
    }

    public IOFile normalize() {
        try {
            return new IOFile(this.toPath().toRealPath(new LinkOption[0]).toFile());
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this;
        }
    }

    private Path toPath() throws IOException {
        try {
            return Paths.get(this.pth, new String[0]);
        }
        catch (InvalidPathException ex) {
            Util.debug(ex);
            throw new IOException(ex);
        }
    }

    private static void addDescendants(IOFile io, StringList files, FileFilter filter, int offset) {
        if (io.isDir()) {
            IOFile[] iOFileArray = io.children(filter);
            int n = iOFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOFile f = iOFileArray[n2];
                IOFile.addDescendants(f, files, filter, offset);
                ++n2;
            }
        } else if (filter == null || filter.accept(io.file)) {
            files.add(io.path().substring(offset));
        }
    }

    public static boolean isValidName(String name) {
        return VALIDNAME.matcher(name).matches();
    }

    public static boolean isValid(String path) {
        int c = path.indexOf(58);
        if (c == -1) {
            return true;
        }
        int fs = path.indexOf(47);
        int bs = path.indexOf(92);
        if (Prop.WIN && c == 1 && Token.letter(path.charAt(0)) && (fs == 2 || bs == 2)) {
            return true;
        }
        return fs != -1 && fs < c || bs != -1 && bs < c;
    }

    public static String regex(String glob) {
        return IOFile.regex(glob, true);
    }

    public static String regex(String glob, boolean sub) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = Strings.split(glob, ',');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String globs = stringArray[n2];
            String glb = globs.trim();
            if (sb.length() != 0) {
                sb.append('|');
            }
            boolean suf = false;
            int gl = glb.length();
            int g = 0;
            while (g < gl) {
                char ch = glb.charAt(g);
                if (ch == '*') {
                    suf = true;
                    sb.append(glb.endsWith(".") ? "[^.]" : ".");
                } else if (ch == '?') {
                    ch = '.';
                    suf = true;
                } else if (ch == '.') {
                    suf = true;
                    if (g + 1 == glb.length()) break;
                    sb.append('\\');
                } else if (!Character.isLetterOrDigit(ch)) {
                    sb.append('\\');
                }
                sb.append(ch);
                ++g;
            }
            if (!suf && sub) {
                sb.append(".*");
            }
            ++n2;
        }
        return Prop.CASE ? sb.toString() : sb.toString().toLowerCase(Locale.ENGLISH);
    }

    private static String create(String path, String last) {
        boolean dir;
        StringList sl = new StringList();
        int l = path.length();
        TokenBuilder tb = new TokenBuilder(l);
        int i = 0;
        while (i < l) {
            char ch = path.charAt(i);
            if (ch == '\\' || ch == '/') {
                IOFile.add(tb, sl);
            } else {
                tb.add(ch);
            }
            ++i;
        }
        IOFile.add(tb, sl);
        if (path.startsWith("\\\\") || path.startsWith("//")) {
            tb.add("//");
        }
        int size = sl.size();
        int s = 0;
        while (s < size) {
            if (s != 0 || path.startsWith("/")) {
                tb.add(47);
            }
            tb.add((String)sl.get(s));
            ++s;
        }
        boolean bl = dir = last.endsWith("/") || last.endsWith("\\");
        if (!dir && Prop.WIN && tb.size() == 2) {
            int c = Character.toLowerCase(tb.get(0));
            boolean bl2 = dir = c >= 97 && c <= 122 && tb.get(1) == 58;
        }
        if (dir) {
            tb.add(47);
        }
        return tb.toString();
    }

    private static void add(TokenBuilder tb, StringList sl) {
        String s = tb.toString();
        if (s.length() > 1 && s.charAt(1) == ':' && sl.isEmpty()) {
            s = String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
        }
        if ("..".equals(s) && !sl.isEmpty()) {
            if (((String)sl.get(sl.size() - 1)).indexOf(58) == -1) {
                sl.remove(sl.size() - 1);
            }
        } else if (!".".equals(s) && !s.isEmpty()) {
            sl.add(s);
        }
        tb.reset();
    }
}

