/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.value.DiskValues;
import org.basex.io.in.DataInput;
import org.basex.util.Token;

final class DiskValuesMerger {
    private final DiskValues dv;
    private final DataInput dk;
    private final String pref;
    private final Data data;
    byte[] key;
    byte[] values;

    DiskValuesMerger(Data data, IndexType type, int i) throws IOException {
        this.pref = String.valueOf(DiskValues.fileSuffix(type)) + i;
        this.dk = new DataInput(data.meta.dbfile(String.valueOf(this.pref) + 't'));
        this.dv = new DiskValues(data, type, this.pref);
        this.data = data;
        this.next();
    }

    void next() throws IOException {
        this.values = this.nextValues();
        if (this.values.length == 0) {
            this.dv.close();
            this.dk.close();
            this.data.meta.drop(String.valueOf(this.pref) + '.');
        } else {
            this.key = this.dk.readToken();
        }
    }

    private byte[] nextValues() {
        return this.dv.idxr.cursor() >= this.dv.idxr.length() ? Token.EMPTY : this.dv.idxl.readBytes(this.dv.idxr.read5(), this.dv.idxl.read4());
    }
}

