/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.IndexTree;
import org.basex.index.IndexType;
import org.basex.index.ValuesBuilder;
import org.basex.index.value.DiskValues;
import org.basex.index.value.DiskValuesMerger;
import org.basex.index.value.UpdatableDiskValues;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.util.Num;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class DiskValuesBuilder
extends ValuesBuilder {
    private IndexTree index;

    public DiskValuesBuilder(Data data, IndexType type) {
        super(data, type);
        this.index = new IndexTree(type);
    }

    @Override
    public DiskValues build() throws IOException {
        Util.debug(this.detailedInfo(), new Object[0]);
        try {
            boolean updindex = this.data.meta.updindex;
            this.pre = 0;
            while (this.pre < this.size) {
                if ((this.pre & 0xFFF) == 0) {
                    this.check();
                }
                if (this.indexEntry()) {
                    int id;
                    int n = id = updindex ? this.data.id(this.pre) : this.pre;
                    if (this.tokenize) {
                        int pos = 0;
                        byte[][] byArray = Token.distinctTokens(this.data.text(this.pre, this.text));
                        int n2 = byArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            byte[] token = byArray[n3];
                            this.index.add(token, id, pos++);
                            ++this.count;
                            ++n3;
                        }
                    } else if (this.data.textLen(this.pre, this.text) <= this.data.meta.maxlen) {
                        this.index.add(this.data.text(this.pre, this.text), id, 0);
                        ++this.count;
                    }
                }
                ++this.pre;
            }
            this.writeIndex(this.splits > 0);
            if (this.splits > 1) {
                this.index = null;
                this.clean();
                this.merge();
            }
            this.finishIndex();
            return updindex ? new UpdatableDiskValues(this.data, this.type) : new DiskValues(this.data, this.type);
        }
        catch (Throwable th) {
            this.data.meta.drop(String.valueOf(DiskValues.fileSuffix(this.type)) + ".+");
            throw th;
        }
    }

    @Override
    protected void check() throws IOException {
        super.check();
        if (this.splitRequired()) {
            this.writeIndex(true);
            this.index = new IndexTree(this.type);
            this.clean();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void merge() throws IOException {
        f = DiskValues.fileSuffix(this.type);
        entries = 0;
        var3_3 = null;
        var4_6 = null;
        try {
            outL = new DataOutput(this.data.meta.dbfile(String.valueOf(f) + 'l'));
            try {
                outR = new DataOutput(this.data.meta.dbfile(String.valueOf(f) + 'r'));
                try {
                    outL.write4(0);
                    ml = new IntList();
                    id = new IntList();
                    pos = this.tokenize != false ? new IntList() : null;
                    vm = new DiskValuesMerger[this.splits];
                    i = 0;
                    while (i < this.splits) {
                        vm[i] = new DiskValuesMerger(this.data, this.type, i);
                        ++i;
                    }
                    while (true) {
                        this.checkStop();
                        min = -1;
                        while (++min < this.splits && vm[min].values.length == 0) {
                        }
                        if (min == this.splits) {
                            break;
                        }
                        ml.reset();
                        i = min;
                        while (i < this.splits) {
                            if (vm[i].values.length != 0 && (d = Token.diff(vm[min].key, vm[i].key)) >= 0) {
                                if (d > 0) {
                                    min = i;
                                    ml.reset();
                                }
                                ml.add(i);
                            }
                            ++i;
                        }
                        ms = ml.size();
                        m = 0;
                        while (m < ms) {
                            t = vm[ml.get(m)];
                            values = t.values;
                            vl = values.length;
                            l = 4;
                            while (l < vl) {
                                id.add(Num.get(values, l));
                                if (pos != null) {
                                    l += Num.length(values, l);
                                    pos.add(Num.get(values, l));
                                }
                                l += Num.length(values, l);
                            }
                            t.next();
                            ++m;
                        }
                        this.write(outL, outR, id, pos);
                        ++entries;
                    }
                }
                finally {
                    if (outR != null) {
                        outR.close();
                    }
                }
                ** if (outL == null) goto lbl-1000
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                if (outL != null) {
                    outL.close();
                }
                throw var3_3;
            }
lbl-1000:
            // 1 sources

            {
                outL.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var4_8) {
            if (var3_3 == null) {
                var3_3 = var4_8;
            } else if (var3_3 != var4_8) {
                var3_3.addSuppressed(var4_8);
            }
            throw var3_3;
        }
        var3_3 = null;
        var4_6 = null;
        try {
            da = new DataAccess(this.data.meta.dbfile(String.valueOf(f) + 'l'));
            try {
                da.write4(entries);
            }
            finally {
                if (da != null) {
                    da.close();
                }
            }
        }
        catch (Throwable var4_9) {
            if (var3_3 == null) {
                var3_3 = var4_9;
            } else if (var3_3 != var4_9) {
                var3_3.addSuppressed(var4_9);
            }
            throw var3_3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeIndex(boolean partial) throws IOException {
        Object var4_6;
        Throwable throwable;
        String name;
        block27: {
            name = String.valueOf(DiskValues.fileSuffix(this.type)) + (partial ? Integer.valueOf(this.splits) : "");
            throwable = null;
            var4_6 = null;
            try {
                DataOutput outL = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 'l'));
                try {
                    try (DataOutput outR = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 'r'));){
                        outL.write4(this.index.size());
                        IntList id = new IntList();
                        IntList pos = this.tokenize ? new IntList() : null;
                        this.index.init();
                        block12: while (this.index.more()) {
                            byte[] values = (byte[])this.index.ids.get(this.index.next());
                            int vs = Num.size(values);
                            if (partial) {
                                outR.write5(outL.size());
                                outL.write(values, 0, vs);
                                continue;
                            }
                            int ip = 4;
                            while (true) {
                                if (ip >= vs) {
                                    this.write(outL, outR, id, pos);
                                    continue block12;
                                }
                                id.add(Num.get(values, ip));
                                if (pos != null) {
                                    ip += Num.length(values, ip);
                                    pos.add(Num.get(values, ip));
                                }
                                ip += Num.length(values, ip);
                            }
                        }
                    }
                    if (outL == null) break block27;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (outL == null) throw throwable;
                    outL.close();
                    throw throwable;
                }
                outL.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        if (partial) {
            throwable = null;
            var4_6 = null;
            try (DataOutput outT = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 't'));){
                this.index.init();
                while (this.index.more()) {
                    outT.writeToken((byte[])this.index.keys.get(this.index.next()));
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        ++this.splits;
    }

    private void write(DataOutput outL, DataOutput outR, IntList id, IntList pos) throws IOException {
        int[] order = null;
        if (this.tokenize) {
            order = id.createOrder();
        } else {
            id.sort();
        }
        int is = id.size();
        outR.write5(outL.size());
        outL.writeNum(is);
        int i = 0;
        int old = 0;
        while (i < is) {
            int value = id.get(i);
            outL.writeNum(value - old);
            if (order != null) {
                outL.writeNum(pos.get(order[i]));
            }
            old = value;
            ++i;
        }
        id.reset();
        if (pos != null) {
            pos.reset();
        }
    }
}

