/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import org.basex.gui.GUIOptions;
import org.basex.gui.view.project.ProjectFile;
import org.basex.gui.view.project.ProjectNode;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;

final class ProjectDir
extends ProjectNode {
    private static final Comparator<IOFile> COMP = (a, b) -> a.path().compareToIgnoreCase(b.path());
    private final ArrayList<IOFile> dirs = new ArrayList();
    private final ArrayList<IOFile> files = new ArrayList();

    ProjectDir(IOFile file, ProjectView view) {
        super(file, view);
        this.addDummy();
    }

    @Override
    void expand() {
        ArrayList<IOFile> newDirs = new ArrayList<IOFile>();
        ArrayList<IOFile> newFiles = new ArrayList<IOFile>();
        boolean hidden = this.view.gui.gopts.get(GUIOptions.HIDDENFILES);
        IOFile[] iOFileArray = this.file.children();
        int n = iOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile child = iOFileArray[n2];
            if (hidden || !child.file().isHidden()) {
                (child.isDir() ? newDirs : newFiles).add(child);
            }
            ++n2;
        }
        newDirs.sort(COMP);
        newFiles.sort(COMP);
        if (!newDirs.equals(this.dirs) || !newFiles.equals(this.files)) {
            this.removeChildren();
            this.dirs.addAll(newDirs);
            this.files.addAll(newFiles);
            for (IOFile f : this.dirs) {
                this.add(new ProjectDir(f, this.view));
            }
            for (IOFile f : this.files) {
                this.add(new ProjectFile(f, this.view));
            }
            this.updateTree();
        }
        this.view.refreshHighlight(this);
    }

    @Override
    void collapse() {
        this.removeChildren();
        this.addDummy();
        this.updateTree();
    }

    @Override
    void refresh() {
        if (this.view.tree.isExpanded(this.path())) {
            this.expand();
        } else {
            this.view.refreshHighlight(this);
        }
        if (this.children != null) {
            for (Object child : this.children) {
                ((ProjectNode)child).refresh();
            }
        }
    }

    private void addDummy() {
        if (this.file.children().length != 0) {
            this.add(new ProjectFile(null, this.view));
        }
    }

    private void removeChildren() {
        this.dirs.clear();
        this.files.clear();
        this.removeAllChildren();
    }

    private void updateTree() {
        ((DefaultTreeModel)this.view.tree.getModel()).nodeStructureChanged(this);
    }

    @Override
    public String toString() {
        String name = this.file.name();
        return name.isEmpty() ? this.file.file().getAbsolutePath() : name;
    }
}

