/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import org.basex.gui.view.map.MapAlgo;
import org.basex.gui.view.map.MapList;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;

final class SquarifiedAlgo
extends MapAlgo {
    SquarifiedAlgo() {
    }

    @Override
    MapRects calcMap(MapRect r, MapList ml, int ns, int ne) {
        ml.sort();
        MapRects rects = new MapRects();
        int ni = ns;
        int start = ns;
        double xx = r.x;
        double yy = r.y;
        double ww = r.w;
        double hh = r.h;
        MapRects row = new MapRects();
        double weight = 0.0;
        double sumweight = 1.0;
        double rowratio = Double.MAX_VALUE;
        while (ni <= ne && xx + ww <= (double)(r.x + r.w) && yy + hh <= (double)(r.y + r.h)) {
            double tmpratio;
            int i;
            MapRects tmp;
            if (ww < hh) {
                int height = (int)((weight += ml.weight[ni]) / sumweight * hh);
                height = height > 0 ? height : 1;
                tmp = new MapRects();
                double x = xx;
                i = start;
                while (i <= ni) {
                    int w = (int)(i == ni ? xx + ww - x : ml.weight[i] / weight * ww);
                    int n = w = w > 0 ? w : 1;
                    if (!(x + (double)w <= xx + ww)) break;
                    tmp.add(new MapRect((int)x, (int)yy, w, height, ml.get(i), r.level));
                    x += (double)w;
                    ++i;
                }
                if ((tmpratio = SquarifiedAlgo.lineRatio(tmp)) > rowratio) {
                    rects.add(row);
                    rowratio = Double.MAX_VALUE;
                    hh -= (double)row.get((int)0).h;
                    yy += (double)row.get((int)0).h;
                    tmp.reset();
                    row.reset();
                    start = ni;
                    sumweight -= weight - ml.weight[ni];
                    weight = 0.0;
                    if (ne != ni) continue;
                    row.add(new MapRect((int)xx, (int)yy, (int)ww, (int)hh, ml.get(ni), r.level));
                    break;
                }
                row = tmp;
                rowratio = tmpratio;
                ++ni;
                continue;
            }
            int width = (int)((weight += ml.weight[ni]) / sumweight * ww);
            width = width > 0 ? width : 1;
            tmp = new MapRects();
            double y = yy;
            i = start;
            while (i <= ni) {
                int h = (int)(i == ni ? yy + hh - y : ml.weight[i] / weight * hh);
                int n = h = h > 0 ? h : 1;
                if (!(y + (double)h <= yy + hh)) break;
                tmp.add(new MapRect((int)xx, (int)y, width, h, ml.get(i), r.level));
                y += (double)h;
                ++i;
            }
            if ((tmpratio = SquarifiedAlgo.lineRatio(tmp)) > rowratio) {
                rects.add(row);
                rowratio = Double.MAX_VALUE;
                ww -= (double)row.get((int)0).w;
                xx += (double)row.get((int)0).w;
                tmp.reset();
                row.reset();
                start = ni;
                sumweight -= weight - ml.weight[ni];
                weight = 0.0;
                if (ne != ni) continue;
                row.add(new MapRect((int)xx, (int)yy, (int)ww, (int)hh, ml.get(ni), r.level));
                break;
            }
            row = tmp;
            rowratio = tmpratio;
            ++ni;
        }
        for (MapRect rect : row) {
            rect.h = (int)hh;
        }
        rects.add(row);
        return rects;
    }
}

