/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public final class TableLayout
implements LayoutManager {
    private final int cols;
    private final int rows;
    private final int insetX;
    private final int insetY;
    private int width;
    private int height;
    private final int[] posX;
    private final int[] posY;

    public TableLayout(int r, int c) {
        this(r, c, 0, 0);
    }

    public TableLayout(int r, int c, int ix, int iy) {
        this.rows = r;
        this.cols = c;
        this.insetX = ix;
        this.insetY = iy;
        this.posX = new int[c];
        this.posY = new int[r];
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets in = parent.getInsets();
            int nr = parent.getComponentCount();
            int maxW = 0;
            int maxH = 0;
            int i = 0;
            while (i < this.cols) {
                this.posX[i] = maxW;
                int w = maxW;
                int h = 0;
                int j = 0;
                while (j < this.rows) {
                    int n = j * this.cols + i;
                    if (n >= nr) break;
                    Component c = parent.getComponent(n);
                    Dimension d = c.getPreferredSize();
                    if (maxW < w + d.width) {
                        maxW = w + d.width;
                    }
                    if (this.posY[j] < h) {
                        this.posY[j] = h;
                    } else {
                        h = this.posY[j];
                    }
                    h += d.height;
                    ++j;
                }
                if (maxH < h) {
                    maxH = h;
                }
                ++i;
            }
            this.width = in.left + maxW + (this.cols - 1) * this.insetX + in.right;
            this.height = in.top + maxH + (this.rows - 1) * this.insetY + in.bottom;
            return new Dimension(this.width, this.height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container p) {
        this.preferredLayoutSize(p);
        Object object = p.getTreeLock();
        synchronized (object) {
            Insets in = p.getInsets();
            int nr = p.getComponentCount();
            int j = 0;
            while (j < this.rows) {
                int i = 0;
                while (i < this.cols) {
                    int n = j * this.cols + i;
                    if (n >= nr) {
                        return;
                    }
                    Dimension cs = p.getComponent(n).getPreferredSize();
                    int x = in.left + this.posX[i] + i * this.insetX;
                    int y = in.top + this.posY[j] + j * this.insetY;
                    int w = cs.width > 0 ? cs.width : this.width - in.left - in.right;
                    int h = cs.height > 0 ? cs.height : this.height - in.top - in.bottom;
                    p.getComponent(n).setBounds(x, y, w, h);
                    ++i;
                }
                ++j;
            }
        }
    }
}

