/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXSerial;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;

public final class DialogExport
extends BaseXDialog {
    private final BaseXCombo path;
    private final BaseXLabel info;
    private final BaseXSerial serial;
    private final BaseXBack buttons;

    public DialogExport(GUI gui) {
        super(gui, Text.EXPORT);
        BaseXBack p = new BaseXBack(new TableLayout(4, 1));
        p.add(new BaseXLabel(String.valueOf(Text.OUTPUT_DIR) + ":", true, true).border(0, 0, 6, 0));
        BaseXBack pp = new BaseXBack(new TableLayout(1, 2, 8, 0));
        this.path = new BaseXCombo((BaseXWindow)this, true, new String[0]).history(GUIOptions.INPUTS, gui.gopts);
        BaseXLayout.setWidth(this.path, 350);
        this.path.setText(gui.gopts.get(GUIOptions.INPUTPATH));
        pp.add(this.path);
        BaseXButton browse = new BaseXButton(this, Text.BROWSE_D);
        browse.addActionListener(e -> this.choose());
        pp.add(browse);
        p.add(pp);
        this.serial = new BaseXSerial(this, gui.context.options.get(MainOptions.EXPORTER));
        this.serial.border(8, 0, 6, 0);
        p.add(this.serial);
        this.info = new BaseXLabel(" ").border(8, 0, 0, 0);
        p.add(this.info);
        this.set(p, "Center");
        pp = new BaseXBack(new BorderLayout());
        this.buttons = this.okCancel();
        pp.add((Component)this.buttons, "East");
        this.set(pp, "South");
        this.action(this.serial);
        this.finish();
    }

    private void choose() {
        IOFile io = new BaseXFileChooser(this, Text.CHOOSE_DIR, this.path.getText()).select(BaseXFileChooser.Mode.DOPEN);
        if (io != null) {
            this.path.setText(io.path());
        }
    }

    public String path() {
        return this.path.getText().trim();
    }

    @Override
    public void action(Object comp) {
        String pth = this.path();
        IOFile io = new IOFile(pth);
        boolean bl = this.ok = !pth.isEmpty();
        if (this.ok) {
            this.gui.gopts.set(GUIOptions.INPUTPATH, pth);
        }
        String text = io.isDir() && io.children().length > 0 ? Text.DIR_NOT_EMPTY : null;
        this.info.setText(text, this.ok ? GUIConstants.Msg.WARN : GUIConstants.Msg.ERROR);
        DialogExport.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        super.close();
        this.gui.set(MainOptions.EXPORTER, this.serial.options());
        this.path.updateHistory();
    }
}

