/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.SingleParser;
import org.basex.build.csv.CsvParser;
import org.basex.build.html.HtmlParser;
import org.basex.build.json.JsonParser;
import org.basex.build.text.TextParser;
import org.basex.build.xml.SAXWrapper;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.util.Atts;

public abstract class Parser
extends Job {
    public IO source;
    protected final Atts atts = new Atts();
    protected final Atts nsp = new Atts();
    protected final MainOptions options;
    String target = "";

    protected Parser(String source, MainOptions options) {
        this(source == null ? null : IO.get(source), options);
    }

    protected Parser(IO source, MainOptions options) {
        this.source = source;
        this.options = options;
    }

    public abstract void parse(Builder var1) throws IOException;

    public void close() throws IOException {
    }

    public String info() {
        return "";
    }

    public Parser target(String path) {
        this.target = path.isEmpty() ? "" : (String.valueOf(path) + '/').replaceAll("//+", "/");
        return this;
    }

    public static Parser emptyParser(MainOptions options) {
        return new Parser(null, options){

            @Override
            public void parse(Builder build) {
            }
        };
    }

    public static SAXWrapper xmlParser(IO source) {
        return new SAXWrapper(source, MainOptions.get());
    }

    public static SingleParser singleParser(IO source, MainOptions options, String target) throws IOException {
        SingleParser p;
        MainOptions.MainParser mp = options.get(MainOptions.PARSER);
        switch (mp) {
            case HTML: {
                p = new HtmlParser(source, options);
                break;
            }
            case TEXT: {
                p = new TextParser(source, options);
                break;
            }
            case JSON: {
                p = new JsonParser(source, options);
                break;
            }
            case CSV: {
                p = new CsvParser(source, options);
                break;
            }
            default: {
                p = options.get(MainOptions.INTPARSE) != false ? new XMLParser(source, options) : new SAXWrapper(source, options);
            }
        }
        p.target(target);
        return p;
    }
}

