/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.cmd.DropDB;
import org.basex.data.DataClip;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.index.name.Names;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.out.TableOutput;
import org.basex.io.random.TableAccess;
import org.basex.io.random.TableDiskAccess;
import org.basex.util.Compress;
import org.basex.util.Inline;
import org.basex.util.Prop;
import org.basex.util.Util;

public final class DiskBuilder
extends Builder {
    private DataOutput tout;
    private DataOutput xout;
    private DataOutput vout;
    private DataOutput sout;
    private final StaticOptions sopts;
    private int c;

    public DiskBuilder(String name, Parser parser, StaticOptions sopts, MainOptions opts) {
        super(name, parser);
        this.sopts = sopts;
        this.meta = new MetaData(this.dbName, opts, sopts);
    }

    @Override
    public DiskData build() throws IOException {
        this.meta.assign(this.parser);
        this.meta.dirty = true;
        Runtime rt = Runtime.getRuntime();
        long max = Math.min(0x400000L, rt.maxMemory() - rt.freeMemory() >> 2);
        int bs = (int)Math.min(this.meta.filesize, max);
        bs = Math.max(4096, bs - bs % 4096);
        DropDB.drop(this.dbName, this.sopts);
        this.sopts.dbPath(this.dbName).md();
        this.elemNames = new Names(this.meta);
        this.attrNames = new Names(this.meta);
        try {
            try {
                this.tout = new DataOutput(new TableOutput(this.meta, "tbl"));
                this.xout = new DataOutput(this.meta.dbfile("txt"), bs);
                this.vout = new DataOutput(this.meta.dbfile("atv"), bs);
                this.sout = new DataOutput(this.meta.dbfile("tmp"), bs);
                this.parse();
            }
            finally {
                if (this.tout != null) {
                    this.tout.close();
                }
                if (this.xout != null) {
                    this.xout.close();
                }
                if (this.vout != null) {
                    this.vout.close();
                }
                if (this.sout != null) {
                    this.sout.close();
                }
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (DataInput in = new DataInput(this.meta.dbfile("tmp"));
                 TableDiskAccess ta = new TableDiskAccess(this.meta, true);){
                while (this.spos < this.ssize) {
                    ((TableAccess)ta).write4(in.readNum(), 8, in.readNum());
                    ++this.spos;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.meta.dbfile("tmp").delete();
            return new DiskData(this.meta, this.elemNames, this.attrNames, this.path, this.nspaces);
        }
        catch (Throwable th) {
            DropDB.drop(this.meta.name, this.sopts);
            throw th;
        }
    }

    @Override
    public DataClip dataClip() throws IOException {
        return new DataClip(this.build());
    }

    @Override
    protected void addDoc(byte[] value) throws IOException {
        this.tout.write1(0);
        this.tout.write2(0);
        this.tout.write5(this.textRef(value, true));
        this.tout.write4(0);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void addElem(int dist, int nameId, int asize, int uriId, boolean ne) throws IOException {
        this.tout.write1(asize << 3 | 1);
        this.tout.write2((ne ? 32768 : 0) | nameId);
        this.tout.write1(uriId);
        this.tout.write4(dist);
        this.tout.write4(asize);
        this.tout.write4(this.meta.size++);
        if (Prop.debug && (this.c++ & 0x7FFFF) == 0) {
            Util.err(".", new Object[0]);
        }
    }

    @Override
    protected void addAttr(int nameId, byte[] value, int dist, int uriId) throws IOException {
        this.tout.write1(dist << 3 | 3);
        this.tout.write2(nameId);
        this.tout.write5(this.textRef(value, false));
        this.tout.write4(uriId);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void addText(byte[] value, int dist, byte kind) throws IOException {
        this.tout.write1(kind);
        this.tout.write2(0);
        this.tout.write5(this.textRef(value, true));
        this.tout.write4(dist);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void setSize(int pre, int size) throws IOException {
        this.sout.writeNum(pre);
        this.sout.writeNum(size);
        ++this.ssize;
    }

    private long textRef(byte[] value, boolean text) throws IOException {
        long inlined = Inline.pack(value);
        if (inlined != 0L) {
            return inlined;
        }
        byte[] packed = Compress.pack(value);
        DataOutput store = text ? this.xout : this.vout;
        long offset = store.size();
        store.writeToken(packed);
        return packed != value ? 0x4000000000L | offset : offset;
    }
}

