# Linux
# gnu compile script for adaventure
# using SOME static libs
#
# static:  SDL2-v2.0.3, SFML-v2.3.2
#
# shared library presence in linux distros:
# 56/77	FLAC   => 73%
# 75/77	ogg
# 22/77	openal => most rare @ 28%
# 76/77	vorbis
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libogg.so.

#########################################################

# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# prepares snd4ada.o file prior to gnatmake...
# using g++ from GNAT:

/usr/gnat/bin/g++ snd4ada.cpp -c -Werror -I./cppinclude -DSFML_STATIC

mv snd4ada.o ./obj/

#########################################################

# this is the typical path of gnat gpl 2015 (20150428):
export PATH=/usr/gnat/bin:$PATH

gnatmake adaventure -o adaventure_gnu_s \
-O2 -gnat12 \
--subdirs=./obj \
-I./adabindings/gl \
-I./adabindings/sdlada \
-I./adabindings/AdaPngLib \
-DSFML_STATIC \
-largs \
-lGL -lz -lstdc++ \
$PWD/libs/gnu/libSDL2.a -lm -lpthread -ldl \
$PWD/libs/gnu/libsfml-audio-s.a \
$PWD/libs/gnu/libsfml-system-s.a \
$PWD/obj/snd4ada.o \
-Xlinker -rpath='$ORIGIN/libs/gnu' \
-L$PWD/libs/gnu \
-lopenal \
-logg -lvorbis -lvorbisenc -lvorbisfile -lFLAC

cp ./obj/adaventure_gnu_s .

cp adaventure_gnu_s adaventure_gnu


# -- Copyright (C) 2016  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

