#version 330 core
layout(location = 0) in vec3 modelPos;
layout(location = 1) in vec2 modelUV;

out vec4 myrgba;
out vec2 UV;

// MVP must match string in glGetUniformLocation(pid,"MVP")
uniform mat4 MVP;
uniform float mytime;
uniform vec3 wPos;
uniform float horiAng;
uniform int direction; //-1=>back, 0=>stop, 1=>forward
uniform int fade; // 0=>nofade, 1=>fade


const vec3 bRad = vec3(0.05,0.19,0.05); // body dimensions
const vec3 fRad = vec3(0.04,0.01,0.03); // feet dimensions
const float fOffy = -0.02; // distance of feet below body
const float fOffz = 0.05; // magnitude of stride
const float fOffx = 0.5; // feet distance apart

// define a ftn giving zoffsets to feet
float walkingDZ( float tm, int dir ) {
	float x=tm*float(dir);
	float dz = fOffz*sin(x);
	if (dir==0) dz=0.0;
	return dz;
} // end walking

float walkingDY( float tm, int dir ) {
	float x=tm*float(dir);
	float dy = 0.4*fOffz*cos(x);
	if (dy<0.0) dy=0.0;
	if (dir==0) dy=0.0;
	return dy+fOffy;
} // end walking

const float onepi = 3.14159;

// avatar is defined as a unit radius cube centered on origin
// made up of 3 rectangular parts (colored, not textured):
// ( -1..+1, 0..+1, -1..+1 ) : Y>0 is main body
// (  0..+1, -1..0, -1..+1 ) : Y<0,X>0 is left foot
// ( -1..0,  -1..0, -1..+1 ) : Y<0,X<0 is right foot




void main(){

	vec3 posrot;
	int id;
	float dz;

	float angl = horiAng+onepi;
	vec3 pos = modelPos;

// here, we must identify 2 feet
// from the lower half cube,
// each foot being half of that
	if (pos.y > 0.0)    id=  0; //body;
	else if (pos.x<0.0) id= -1; //rfoot;
	else                id= +1; //lfoot;



	if (id==0) {             //main body

		// we assume original setup with unitary radii
		pos.x *= bRad.x;
		pos.y *= bRad.y; //compensate for short Y-dimension
		pos.z *= bRad.z;
		// now is expanded to proper size

		if( modelPos.z > 0.5 ) { // front face
			if( modelPos.y < 0.5 ) 
				myrgba=vec4(1.0,1.0,1.0,1.0); //white breast
			else
				myrgba=vec4(0.0,0.0,0.0,1.0); //black head
		}
		else myrgba = vec4(0.0,0.0,0.0,1.0); //black body

	} // end main body
	else if (id<0) {       //rightFoot

		// we assume original setup with unitary radii
		pos.x -= fOffx;
		pos.x *= fRad.x;
		pos.y *= fRad.y; //compensate for short Y-dimension
		pos.z *= fRad.z;
		// now is expanded to proper size

		myrgba = vec4(1.0,0.615,0.063,1.0); //duck feet color

	} // end rightFoot
	else {                   // leftFoot

		// we assume original setup with unitary radii
		pos.x += fOffx;
		pos.x *= fRad.x;
		pos.y *= fRad.y; //compensate for short Y-dimension
		pos.z *= fRad.z;
		// now is expanded to proper size

		myrgba = vec4(1.0,0.615,0.063,1.0); //duck feet color

	} // end leftFoot



// feet need to walk here, BEFORE rotation
	if (id != 0) 
		if (id<0 ) { //rightFoot
			pos.z += walkingDZ(15.0*mytime,direction);
			pos.y += walkingDY(15.0*mytime,direction);
		} else if (id>0) { //leftFoot
			pos.z += walkingDZ(15.0*mytime+onepi,direction);
			pos.y += walkingDY(15.0*mytime+onepi,direction);
		}


	// rotate per attitude
	posrot.y = pos.y;
	posrot.x = +cos(angl)*pos.x + sin(angl)*pos.z;
	posrot.z = -sin(angl)*pos.x + cos(angl)*pos.z;
	// now is rotated to proper look-direction

	//posrot = pos; // debugging-only (shows side view of tux)

	// translate into position
	posrot += wPos;
	posrot.y += 0.04; // adjustment to put feet on ground

	if( fade>0 ) myrgba.a = 0.5; //showing glyph


	gl_Position =  MVP * vec4(posrot,1.0);

	UV = modelUV;

}


//--
//-- Copyright (C) 2016  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

