
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;  use gl;
with ada.finalization;
with unchecked_deallocation;




package avatarobj is
-- textured object made up of 3 rectangles:
-- ( -1..+1, 0..+1, -1..+1 ) : Y>0 is main body
-- (  0..+1, -1..0, -1..+1 ) : X>0 is left foot
-- ( -1..0,  -1..0, -1..+1 ) : X<0 is right foot



type avatar is tagged private;

procedure setrect( rx: avatar );


procedure draw( rx: avatar;  vertbuff, uvbuff, elembuff : gluint );



private

nvert : constant integer := 72*3;
nelm : constant integer := 36*3;
nuv : constant integer := 48*3;


type varray is array(1..nvert) of float;
type vap is access varray;

type tarray is array(1..nuv) of float;
type tap is access tarray;

type earray is array(1..nelm) of glushort;
type eap is access earray;


type avatar is new ada.finalization.controlled with record
vert : vap;
elem : eap;
txuv : tap;
end record;

procedure initialize( rx: in out avatar );
procedure finalize( rx: in out avatar );


end avatarobj;

