
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with system;
with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

with interfaces.c;
use type interfaces.c.unsigned_short;


with ada.finalization;
with unchecked_deallocation;

with text_io;


package body avatarobj is -- normals to show exterior...
-- rectangular object made up of 3 sub-rectangles:
-- ( [-1..1] ( 0..1] [-1..1] ) : Y>0 is main body
-- ( ( 0..1] [-1..0) [-1..1] ) : X>0 is left foot
-- ( [-1..0) [-1..0) [-1..1] ) : X<0 is right foot
-- to be colored by a special frag.shader






procedure initialize( rx: in out avatar ) is
begin
	rx.vert := new varray;
	rx.elem := new earray;
	rx.txuv := new tarray;
end initialize;

procedure vfree is new unchecked_deallocation(varray,vap);
procedure efree is new unchecked_deallocation(earray,eap);
procedure tfree is new unchecked_deallocation(tarray,tap);

procedure finalize( rx: in out avatar ) is
begin
	vfree( rx.vert );
	efree( rx.elem );
	tfree( rx.txuv );
end finalize;







procedure setrect( rx: avatar ) is

	xc,yc,zc,xr,yr,zr,
	xm,xp,ym,yp,zm,zp : float;

	j,k,t : integer := 0;
	jj : glushort := 0;

	umin, vmin,
	umax, vmax : float;

begin


-- main body:


	xc:=0.0; xr:=1.0; 
	zc:=0.0; zr:=1.0;
	yc:=0.5; yr:=0.49; --upper half

	xm := xc-xr;
	xp := xc+xr;
	ym := yc-yr;
	yp := yc+yr;
	zm := zc-zr;
	zp := zc+zr;


	-- front
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zp;
	k:=k+12;

	-- top
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=yp;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=yp;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;


	-- back
	rx.vert(k+ 1):=xp;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xm;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xm;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xp;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;

	-- bottom
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=ym;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=ym;  rx.vert(k+12):=zp;
	k:=k+12;


	-- left
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xm;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xm;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;

	-- right
	rx.vert(k+ 1):=xp;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xp;  rx.vert(k+11):=yp;  rx.vert(k+12):=zp;
	k:=k+12;



	-- texture UV coords for cube:
	for i in 0..5 loop

		if  i=0  then
			umin:= 0.5;  umax:= 1.0; -- penguin face
			vmin:= 0.0;  vmax:= 1.0;
		else --black
			umin:= 0.0;  umax:= 0.5;
			vmin:= 0.5;  vmax:= 1.0;
		end if;

		rx.txuv(t+1):=umin;  rx.txuv(t+2):=vmin;
		rx.txuv(t+3):=umax;  rx.txuv(t+4):=vmin;
		rx.txuv(t+5):=umax;  rx.txuv(t+6):=vmax;
		rx.txuv(t+7):=umin;  rx.txuv(t+8):=vmax;
		t:=t+8;

	end loop;



	-- element indices:
	for i in 0..5 loop
		rx.elem(j+1):=jj+0;
		rx.elem(j+2):=jj+1;
		rx.elem(j+3):=jj+2;
		rx.elem(j+4):=jj+2;
		rx.elem(j+5):=jj+3;
		rx.elem(j+6):=jj+0;
		jj:=jj+4;
		j:=j+6;
	end loop;


--------- end main body;  begin left foot


	xc:=0.5; xr:=0.49;  --left half
	zc:=0.0; zr:=1.0;
	yc:=-0.5; yr:=0.49; --lower half

	xm := xc-xr;
	xp := xc+xr;
	ym := yc-yr;
	yp := yc+yr;
	zm := zc-zr;
	zp := zc+zr;


	-- front
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zp;
	k:=k+12;

	-- top
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=yp;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=yp;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;


	-- back
	rx.vert(k+ 1):=xp;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xm;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xm;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xp;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;

	-- bottom
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=ym;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=ym;  rx.vert(k+12):=zp;
	k:=k+12;


	-- left
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xm;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xm;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;

	-- right
	rx.vert(k+ 1):=xp;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xp;  rx.vert(k+11):=yp;  rx.vert(k+12):=zp;
	k:=k+12;




	-- texture UV coords for cube:
	for i in 0..5 loop

		umin:= 0.0;  umax:= 0.5; -- beak, feet color
		vmin:= 0.0;  vmax:= 0.5;

		rx.txuv(t+1):=umin;  rx.txuv(t+2):=vmin;
		rx.txuv(t+3):=umax;  rx.txuv(t+4):=vmin;
		rx.txuv(t+5):=umax;  rx.txuv(t+6):=vmax;
		rx.txuv(t+7):=umin;  rx.txuv(t+8):=vmax;
		t:=t+8;

	end loop;



	-- element indices:
	for i in 0..5 loop
		rx.elem(j+1):=jj+0;
		rx.elem(j+2):=jj+1;
		rx.elem(j+3):=jj+2;
		rx.elem(j+4):=jj+2;
		rx.elem(j+5):=jj+3;
		rx.elem(j+6):=jj+0;
		jj:=jj+4;
		j:=j+6;
	end loop;




--------- end left foot;  begin right foot

	xc:=-0.5; xr:=0.49; --right half
	zc:=0.0; zr:=1.0;
	yc:=-0.5; yr:=0.49; --lower half

	xm := xc-xr;
	xp := xc+xr;
	ym := yc-yr;
	yp := yc+yr;
	zm := zc-zr;
	zp := zc+zr;


	-- front
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zp;
	k:=k+12;

	-- top
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=yp;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=yp;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;


	-- back
	rx.vert(k+ 1):=xp;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xm;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xm;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xp;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;

	-- bottom
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=ym;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=ym;  rx.vert(k+12):=zp;
	k:=k+12;


	-- left
	rx.vert(k+ 1):=xm;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zm;
	rx.vert(k+ 4):=xm;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zp;
	rx.vert(k+ 7):=xm;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zp;
	rx.vert(k+10):=xm;  rx.vert(k+11):=yp;  rx.vert(k+12):=zm;
	k:=k+12;

	-- right
	rx.vert(k+ 1):=xp;  rx.vert(k+ 2):=ym;  rx.vert(k+ 3):=zp;
	rx.vert(k+ 4):=xp;  rx.vert(k+ 5):=ym;  rx.vert(k+ 6):=zm;
	rx.vert(k+ 7):=xp;  rx.vert(k+ 8):=yp;  rx.vert(k+ 9):=zm;
	rx.vert(k+10):=xp;  rx.vert(k+11):=yp;  rx.vert(k+12):=zp;
	k:=k+12;


	-- texture UV coords for cube:
	for i in 0..5 loop

		umin:= 0.0;  umax:= 0.5; -- beak, feet color
		vmin:= 0.0;  vmax:= 0.5;

		rx.txuv(t+1):=umin;  rx.txuv(t+2):=vmin;
		rx.txuv(t+3):=umax;  rx.txuv(t+4):=vmin;
		rx.txuv(t+5):=umax;  rx.txuv(t+6):=vmax;
		rx.txuv(t+7):=umin;  rx.txuv(t+8):=vmax;
		t:=t+8;

	end loop;




	-- element indices:
	for i in 0..5 loop
		rx.elem(j+1):=jj+0;
		rx.elem(j+2):=jj+1;
		rx.elem(j+3):=jj+2;
		rx.elem(j+4):=jj+2;
		rx.elem(j+5):=jj+3;
		rx.elem(j+6):=jj+0;
		jj:=jj+4;
		j:=j+6;
	end loop;


	if k/=nvert or j/=nelm or t/=nuv then
		raise constraint_error;
	end if;



end setrect;



-- note:  must allow the shaders to show transparency

use gl;
use glext;
use glext.binding;
use gl.binding;

procedure draw( rx: avatar;  vertbuff, uvbuff, elembuff : gluint ) is
begin

	-- 0th attribute:  vertices
	glBindBuffer(gl_array_buffer, vertbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nvert), rx.vert(1)'address, gl_static_draw);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0,3,gl_float,gl_false,0, system.null_address);

	-- 1st attribute:  texture UV
	glBindBuffer(gl_array_buffer, uvbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nuv), rx.txuv(1)'address, gl_static_draw);
	glEnableVertexAttribArray(1);
	glVertexAttribPointer(1,2,gl_float,gl_false,0, system.null_address);

	-- element indices:
	glBindBuffer(gl_element_array_buffer, elembuff);
	glBufferData(gl_element_array_buffer, glsizeiptr(2*nelm), rx.elem(1)'address, gl_static_draw);

--allow transparency
gl.binding.glenable(gl_blend);
gl.binding.glblendfunc(gl_src_alpha, gl_one_minus_src_alpha);


	glDrawElements( gl_triangles, glint(nvert), gl_unsigned_short, system.null_address );


gl.binding.gldisable(gl_blend);

	glDisableVertexAttribArray(0);

end draw;



end avatarobj;

