/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui.swing.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.talisman.mds.ui.swing.CurrentDirectoryHandler;
import jp.sourceforge.talisman.mds.ui.swing.MdsPane;
import jp.sourceforge.talisman.mds.ui.swing.MdsViewerPane;
import jp.sourceforge.talisman.mds.ui.swing.actions.ExtensionFileFilter;

public class StoreMdsImageAction
extends AbstractAction {
    private static final long serialVersionUID = 445562293718912259L;
    private MdsViewerPane mds;
    private CurrentDirectoryHandler handler;
    private Component parent;

    public StoreMdsImageAction(MdsViewerPane mds) {
        this(mds, mds, mds);
    }

    public StoreMdsImageAction(Component parent, MdsViewerPane mds) {
        this(parent, mds, mds);
    }

    public StoreMdsImageAction(Component parent, MdsViewerPane mds, CurrentDirectoryHandler handler) {
        super(mds.getMessages().get("store.image.label"));
        this.parent = parent;
        this.mds = mds;
        this.handler = handler;
        if (mds.getMessages().hasValue("store.image.tooltip")) {
            this.putValue("ShortDescription", mds.getMessages().get("store.image.tooltip"));
        }
        if (mds.getMessages().hasValue("store.image.icon")) {
            Icon icon = mds.getMessages().getIcon("store.image.icon");
            this.putValue("SmallIcon", icon);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.handler.getCurrentDirectory());
        chooser.addChoosableFileFilter(new ExtensionFileFilter("jpg", "JPEG Image"));
        chooser.addChoosableFileFilter(new ExtensionFileFilter("png", "PNG Image"));
        chooser.setMultiSelectionEnabled(false);
        int value = chooser.showSaveDialog(this.parent);
        if (value == 0) {
            this.handler.setCurrentDirectory(chooser.getCurrentDirectory());
            FileFilter filter = chooser.getFileFilter();
            File target = chooser.getSelectedFile();
            if (!filter.accept(target) && filter instanceof ExtensionFileFilter) {
                target = new File(target.getParentFile(), target.getName() + "." + ((ExtensionFileFilter)filter).getExtension());
            }
            this.storeImage(target);
        }
    }

    private BufferedImage createImage() {
        MdsPane pane = this.findMdsPane(this.mds);
        BufferedImage image = new BufferedImage(pane.getWidth(), pane.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        pane.paint(g);
        g.dispose();
        return image;
    }

    private void storeImage(File file) {
        String fileName = file.getName();
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        try {
            ImageIO.write((RenderedImage)this.createImage(), extension, file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, this.mds.getMessages().get("show.error.io.message") + "\r\n" + e.getMessage(), this.mds.getMessages().get("show.error.dialog.title"), 0);
        }
    }

    private MdsPane findMdsPane(Container mds) {
        Component[] components = mds.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof MdsPane) {
                return (MdsPane)components[i];
            }
            if (!(components[i] instanceof Container)) continue;
            return this.findMdsPane((Container)components[i]);
        }
        return null;
    }
}

