/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.distance.AbstractItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class NormalizedEuclideanItemDistanceCalculator
extends AbstractItemDistanceCalculator {
    public double calculate(double[] x, double[] y) {
        this.validateArguments(x, y);
        double xbar = this.calculateBar(x);
        double ybar = this.calculateBar(y);
        double value = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            double zx = (x[i] - xbar) / (2.0 / x[i]);
            double zy = (y[i] - ybar) / (2.0 / y[i]);
            value += (zx - zy) * (zx - zy);
        }
        return Math.sqrt(value);
    }

    public ItemDistanceAlgorithm getAlgorithm() {
        return ItemDistanceAlgorithm.NORMALIZED_EUCLIDEAN_DISTANCE;
    }

    private double calculateBar(double[] val) {
        int num = 0;
        double v = 0.0;
        for (int i = 0; i < val.length; ++i) {
            if (Double.isNaN(val[i])) continue;
            ++num;
            v += val[i];
        }
        return v / (double)num;
    }
}

