/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.distance.AbstractClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class FurthestNeighborClusterDistanceCalculator
extends AbstractClusterDistanceCalculator {
    public FurthestNeighborClusterDistanceCalculator() {
    }

    public FurthestNeighborClusterDistanceCalculator(ItemDistanceAlgorithm ida) {
        super(ida);
    }

    public ClusterDistanceAlgorithm getAlgorithm() {
        return ClusterDistanceAlgorithm.FURTHEST_NEIGHBOR_METHOD;
    }

    public double calculate(Cluster c1, Cluster c2) {
        double furthest = 0.0;
        for (Item item1 : c1) {
            for (Item item2 : c2) {
                double value = this.getItemDistanceCalculator().calculate(item1, item2);
                if (!(furthest < value)) continue;
                furthest = value;
            }
        }
        return furthest;
    }

    public double update(Cluster ci, Cluster cj, Cluster ck, double dij, double dik, double djk) {
        return dik / 2.0 + djk / 2.0 + Math.abs(dik - djk) / 2.0;
    }
}

